/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.snapshot.SnapshotFile;
import com.integ.supporter.snapshot.SnapshotLogFile;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Logger;

public class AnalyzeSnapshots {
    private static int MaxRecordUptime = 0;
    private static int MaxTotalUptime = 0;

    private AnalyzeSnapshots() {
    }

    public static void analyze(ArrayList<SnapshotFile> snapshotFiles2) {
        Integer value;
        String key;
        final ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        ArrayList futures = new ArrayList();
        final Hashtable supportToolVersionsCountHash = new Hashtable();
        final Hashtable osVersionsCountHash = new Hashtable();
        final CountDownLatch countDownLatch = new CountDownLatch(snapshotFiles2.size());
        while (0 < snapshotFiles2.size()) {
            final SnapshotFile snapshotFile = snapshotFiles2.remove(0);
            System.out.println("snapshotFiles count = " + snapshotFiles2.size());
            Future<?> future = executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SnapshotLogFile snapshotLogFile = new SnapshotLogFile(snapshotFile);
                    try {
                        snapshotLogFile.analyze();
                        ThreadPoolExecutor threadPoolExecutor = executor;
                        synchronized (threadPoolExecutor) {
                            int totalUptime;
                            String supportToolVersion = snapshotLogFile.getSupportToolVersion();
                            System.out.println("Support Tool Version = " + supportToolVersion);
                            Hashtable hashtable = supportToolVersionsCountHash;
                            synchronized (hashtable) {
                                if (!supportToolVersionsCountHash.containsKey(supportToolVersion)) {
                                    supportToolVersionsCountHash.put(supportToolVersion, 0);
                                }
                                int count = (Integer)supportToolVersionsCountHash.get(supportToolVersion);
                                supportToolVersionsCountHash.put(supportToolVersion, count + 1);
                            }
                            System.out.println("SerialNumber = " + snapshotLogFile.getSerialNumber());
                            System.out.println("Series = " + snapshotLogFile.getSeries());
                            System.out.println("Model = " + snapshotLogFile.getModel());
                            String osVersion = snapshotLogFile.getOsVersion();
                            System.out.println("osVersion = " + osVersion);
                            Hashtable count = osVersionsCountHash;
                            synchronized (count) {
                                if (!osVersionsCountHash.containsKey(osVersion)) {
                                    osVersionsCountHash.put(osVersion, 0);
                                }
                                int count2 = (Integer)osVersionsCountHash.get(osVersion);
                                osVersionsCountHash.put(osVersion, count2 + 1);
                            }
                            int recordUptime = snapshotLogFile.getRecordUptime();
                            if (recordUptime > MaxRecordUptime) {
                                MaxRecordUptime = recordUptime;
                                System.out.println("new max record uptime in days = " + MaxRecordUptime);
                            }
                            if ((totalUptime = snapshotLogFile.getTotalUptime()) > MaxTotalUptime) {
                                MaxTotalUptime = totalUptime;
                                System.out.println("new max total uptime in days = " + MaxTotalUptime);
                            }
                            ArrayList<String> applications = snapshotLogFile.getApplications();
                            for (String application : applications) {
                                System.out.println("application = " + application);
                            }
                            ArrayList<String> listeningPorts = snapshotLogFile.getListeningPorts();
                            for (String listeningPort : listeningPorts) {
                                System.out.println("listeningPort = " + listeningPort);
                            }
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("error with snapshotFile = " + snapshotFile.getFile().getPath());
                        System.out.println(snapshotLogFile.getSnapshotLogContent());
                        ex.printStackTrace();
                        Logger.getLogger(AnalyzeSnapshots.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(AnalyzeSnapshots.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
        }
        System.out.println("Support Tool Versions:");
        for (Map.Entry entry : supportToolVersionsCountHash.entrySet()) {
            key = (String)entry.getKey();
            value = (Integer)entry.getValue();
            System.out.println("   " + key + " = " + value);
        }
        System.out.println("JNIOR OS Versions:");
        for (Map.Entry entry : osVersionsCountHash.entrySet()) {
            key = (String)entry.getKey();
            value = (Integer)entry.getValue();
            System.out.println("   " + key + " = " + value);
        }
        executor.shutdown();
    }
}

