/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginDialog2
extends JDialog {
    private String CMD_CANCEL = "cmd.cancel";
    private String CMD_HELP = "cmd.help";
    private String CMD_LOGIN = "cmd.login";
    public static final int RET_CANCEL = 0;
    public static final int RET_LOGIN = 1;
    private int result = 0;
    private JTextField userNameTextField = null;
    private JPasswordField passwordField = null;
    private JButton loginButton = null;
    private static final Object sharedFrameKey = LoginDialog2.class;

    public LoginDialog2(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pack();
    }

    public LoginDialog2(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pack();
    }

    public int getResult() {
        return this.result;
    }

    public String getUsername() {
        return this.userNameTextField.getText();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public void centerParent() {
        Container myParent = this.getParent();
        Point topLeft = myParent.getLocationOnScreen();
        Dimension parentSize = myParent.getSize();
        Dimension mySize = this.getSize();
        int x = parentSize.width > mySize.width ? (parentSize.width - mySize.width) / 2 + topLeft.x : topLeft.x;
        int y = parentSize.height > mySize.height ? (parentSize.height - mySize.height) / 2 + topLeft.y : topLeft.y;
        this.setLocation(x, y);
        this.requestFocus();
    }

    private void initComponents() {
        GridBagConstraints constraint = null;
        Container contents = this.getContentPane();
        contents.setLayout(new GridBagLayout());
        this.setTitle("Login");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                LoginDialog2.this.windowAction(LoginDialog2.this.CMD_CANCEL);
            }
        });
        this.userNameTextField = new JTextField();
        JLabel userNameLabel = new JLabel();
        userNameLabel.setDisplayedMnemonic('U');
        userNameLabel.setLabelFor(this.userNameTextField);
        userNameLabel.setText("User Name");
        constraint = new GridBagConstraints();
        constraint.anchor = 17;
        constraint.insets = new Insets(12, 12, 0, 0);
        contents.add((Component)userNameLabel, constraint);
        this.userNameTextField.setToolTipText("Enter User Name Here");
        this.userNameTextField.setPreferredSize(new Dimension(150, 19));
        constraint = new GridBagConstraints();
        constraint.gridx = 1;
        constraint.fill = 2;
        constraint.weightx = 2.0;
        constraint.insets = new Insets(12, 7, 0, 11);
        contents.add((Component)this.userNameTextField, constraint);
        this.passwordField = new JPasswordField();
        JLabel passwordLabel = new JLabel();
        passwordLabel.setDisplayedMnemonic('P');
        passwordLabel.setText("Password");
        passwordLabel.setLabelFor(this.passwordField);
        constraint = new GridBagConstraints();
        constraint.gridy = 1;
        constraint.anchor = 17;
        constraint.weightx = 1.0;
        constraint.insets = new Insets(11, 12, 0, 0);
        contents.add((Component)passwordLabel, constraint);
        this.passwordField.setToolTipText("Enter Password Here");
        this.passwordField.setPreferredSize(new Dimension(150, 19));
        this.passwordField.setEchoChar('\u2022');
        constraint = new GridBagConstraints();
        constraint.gridx = 1;
        constraint.gridy = 1;
        constraint.fill = 2;
        constraint.weightx = 1.0;
        constraint.insets = new Insets(11, 7, 0, 11);
        contents.add((Component)this.passwordField, constraint);
        JPanel buttonPanel = this.createButtonPanel();
        constraint = new GridBagConstraints();
        constraint.gridy = 2;
        constraint.anchor = 13;
        constraint.gridwidth = 2;
        constraint.insets = new Insets(17, 12, 11, 11);
        contents.add((Component)buttonPanel, constraint);
        this.getRootPane().setDefaultButton(this.loginButton);
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.loginButton = new JButton();
        this.loginButton.setText("Login");
        this.loginButton.setToolTipText("Click to Login");
        this.loginButton.setActionCommand(this.CMD_LOGIN);
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LoginDialog2.this.windowAction(event);
            }
        });
        panel.add(this.loginButton);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.setActionCommand(this.CMD_CANCEL);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LoginDialog2.this.windowAction(event);
            }
        });
        panel.add(cancelButton);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        Vector<JButton> buttons = new Vector<JButton>(2);
        buttons.add(this.loginButton);
        buttons.add(cancelButton);
        this.equalizeComponentSizes(buttons);
        buttons.removeAllElements();
        return panel;
    }

    private void equalizeComponentSizes(List components) {
        int i = 0;
        Dimension maxPreferred = new Dimension(0, 0);
        JComponent oneComponent = null;
        Dimension thisPreferred = null;
        for (i = 0; i < components.size(); ++i) {
            oneComponent = (JComponent)components.get(i);
            thisPreferred = oneComponent.getPreferredSize();
            maxPreferred.width = Math.max(maxPreferred.width, (int)thisPreferred.getWidth());
            maxPreferred.height = Math.max(maxPreferred.height, (int)thisPreferred.getHeight());
        }
        for (i = 0; i < components.size(); ++i) {
            oneComponent = (JComponent)components.get(i);
            oneComponent.setPreferredSize((Dimension)maxPreferred.clone());
            oneComponent.setMaximumSize((Dimension)maxPreferred.clone());
        }
    }

    private void windowAction(Object actionCommand) {
        String cmd = null;
        if (actionCommand != null) {
            cmd = actionCommand instanceof ActionEvent ? ((ActionEvent)actionCommand).getActionCommand() : actionCommand.toString();
        }
        if (cmd != null) {
            if (cmd.equals(this.CMD_CANCEL)) {
                this.result = 0;
            } else if (cmd.equals(this.CMD_LOGIN)) {
                this.result = 1;
            }
        }
        this.setVisible(false);
        this.dispose();
    }
}

