/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.supporter.SupporterMain;
import com.integ.supporter.cinema.macro.LocalMacroFile;
import com.integ.supporter.cinema.macro.MacroTab;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;

public class LocalMacroFileOpener {
    public LocalMacroFileOpener(Component parent) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(SupporterMain.CINEMA_FILES_FOLDER));
        fileChooser.setFileSelectionMode(0);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String filename = file.getName();
                return filename.startsWith("macro") && filename.endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return "Macro Files";
            }
        });
        fileChooser.setAcceptAllFileFilterUsed(true);
        int result = fileChooser.showOpenDialog(parent);
        if (result == 0) {
            LocalMacroFile macroFile = new LocalMacroFile(fileChooser.getSelectedFile());
            MacroTab macroTab = new MacroTab(macroFile);
            JTabbedPane tabbedPane = SupporterMain.getTabPane();
            String title = String.format("Macro - %s", macroFile.getTitle());
            int tabCount = tabbedPane.getTabCount();
            tabbedPane.insertTab(title, null, macroTab, title, tabCount);
            tabbedPane.setSelectedIndex(tabCount);
        }
    }
}

