/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.backup;

import com.integ.janoslib.utils.FileUtils;
import com.integ.supporter.SupporterMain;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BackupServicesConfig {
    private static final File BACKUP_SERVICES_CONFIG_JSON_FILE = new File(SupporterMain.CONFIG_DIRECTORY + "BackupServicesConfig.json");
    private static final BackupServicesConfig INSTANCE = new BackupServicesConfig();
    private JSONObject _backupServicesConfigJson = new JSONObject();
    private JSONObject _jniorsJson = null;
    private JSONObject _excludesJson = null;

    private BackupServicesConfig() {
    }

    public static void init() {
        INSTANCE.loadBackupServicesJson();
    }

    private void loadBackupServicesJson() {
        try {
            if (BACKUP_SERVICES_CONFIG_JSON_FILE.exists()) {
                String backupServicesJsonFileContent = FileUtils.readAllText(BACKUP_SERVICES_CONFIG_JSON_FILE.getPath());
                this._backupServicesConfigJson = new JSONObject(backupServicesJsonFileContent);
            } else {
                this._backupServicesConfigJson = new JSONObject();
            }
            if (this._backupServicesConfigJson.has("Jniors")) {
                this._jniorsJson = this._backupServicesConfigJson.getJSONObject("Jniors");
            } else {
                this._jniorsJson = new JSONObject();
                this._backupServicesConfigJson.put("Jniors", this._jniorsJson);
            }
            if (this._backupServicesConfigJson.has("Excludes")) {
                this._excludesJson = this._backupServicesConfigJson.getJSONObject("Excludes");
            } else {
                this._excludesJson = new JSONObject();
                this._backupServicesConfigJson.put("Excludes", this._excludesJson);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void saveConfig() {
        try {
            String backupServicesJsonFileContent = this._backupServicesConfigJson.toString(2);
            FileUtils.writeAllBytes(BACKUP_SERVICES_CONFIG_JSON_FILE.getPath(), backupServicesJsonFileContent.getBytes());
        }
        catch (IOException | JSONException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled() {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            boolean enabled = false;
            if (BackupServicesConfig.INSTANCE._backupServicesConfigJson.has("Enabled")) {
                enabled = BackupServicesConfig.INSTANCE._backupServicesConfigJson.getBoolean("Enabled");
            }
            return enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnabled(boolean isEnabled) {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            BackupServicesConfig.INSTANCE._backupServicesConfigJson.put("Enabled", isEnabled);
            INSTANCE.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getBackupIntervalInHours() {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            if (!BackupServicesConfig.INSTANCE._backupServicesConfigJson.has("BackupIntervalInHours")) {
                BackupServicesConfig.INSTANCE._backupServicesConfigJson.put("BackupIntervalInHours", 12);
            }
            double backupIntervalInHours = BackupServicesConfig.INSTANCE._backupServicesConfigJson.getDouble("BackupIntervalInHours");
            return backupIntervalInHours;
        }
    }

    private JSONObject getJsonForJnior(int serialNumber) {
        JSONObject jniorJson = null;
        String serialNumberString = String.valueOf(serialNumber);
        jniorJson = this._jniorsJson.has(serialNumberString) ? this._jniorsJson.getJSONObject(serialNumberString) : new JSONObject();
        return jniorJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastBackupTimeForJnior(int serialNumber) {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            JSONObject jniorJson = INSTANCE.getJsonForJnior(serialNumber);
            if (jniorJson.has("LastBackupTime")) {
                long lastBackupTime = jniorJson.getLong("LastBackupTime");
                return lastBackupTime;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLastBackupTimeForJnior(int serialNumber, long lastBackupTime) {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            JSONObject jniorJson = INSTANCE.getJsonForJnior(serialNumber);
            jniorJson.put("LastBackupTime", lastBackupTime);
            jniorJson.put("LastBackupTimeString", new Date(lastBackupTime));
            String serialNumberString = String.valueOf(serialNumber);
            BackupServicesConfig.INSTANCE._jniorsJson.put(serialNumberString, jniorJson);
            INSTANCE.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getExcludesIpAddressArray() {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            if (!BackupServicesConfig.INSTANCE._excludesJson.has("IpAddresses")) {
                BackupServicesConfig.INSTANCE._excludesJson.put("IpAddresses", new String[0]);
                INSTANCE.saveConfig();
            }
            JSONArray jsonArray = BackupServicesConfig.INSTANCE._excludesJson.getJSONArray("IpAddresses");
            String[] stringArray = new String[jsonArray.length()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = jsonArray.getString(i);
            }
            return stringArray;
        }
    }

    public static void addExcludeIpAddress(String ipAddress) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getExcludesHostnameArray() {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            if (!BackupServicesConfig.INSTANCE._excludesJson.has("Hostnames")) {
                BackupServicesConfig.INSTANCE._excludesJson.put("Hostnames", new String[0]);
                INSTANCE.saveConfig();
            }
            JSONArray jsonArray = BackupServicesConfig.INSTANCE._excludesJson.getJSONArray("Hostnames");
            String[] stringArray = new String[jsonArray.length()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = jsonArray.getString(i);
            }
            return stringArray;
        }
    }
}

