/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.utils.ArrayUtils;
import com.integ.janoslib.utils.ExceptionUtils;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;
import java.util.logging.Logger;

public class NTPClient {
    private static final Object LOCK = new Object();
    private static final String NTP_SERVER = "pool.ntp.org";
    private static Date _lastNtpTime = null;
    private static long _localOffset = 0L;
    private static long _elapsedTime;

    public static long getOffset() {
        return _localOffset;
    }

    public static double getElapsedTime() {
        return (double)_elapsedTime / 1000.0;
    }

    public static Date getNetworkTime() {
        return NTPClient.getNetworkTime(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getNetworkTime(boolean force) {
        Object object = LOCK;
        synchronized (object) {
            if (force || null == _lastNtpTime) {
                NTPClient.doNtpRequest();
            }
            return _lastNtpTime;
        }
    }

    private static void doNtpRequest() {
        try {
            Logger.getGlobal().info("Get Network Time from pool.ntp.org");
            long start = System.currentTimeMillis();
            byte[] ntpData = new byte[48];
            ntpData[0] = 27;
            InetAddress ipAddress = InetAddress.getByName(NTP_SERVER);
            DatagramPacket packet = new DatagramPacket(ntpData, ntpData.length, ipAddress, 123);
            try (DatagramSocket socket = new DatagramSocket();){
                socket.send(packet);
                socket.setSoTimeout(3000);
                DatagramPacket inPacket = new DatagramPacket(ntpData, ntpData.length);
                socket.receive(inPacket);
            }
            int transmitTimestampIndex = 40;
            long intPart = (long)ArrayUtils.getInt(ntpData, transmitTimestampIndex) & 0xFFFFFFFFL;
            long fractPart = (long)ArrayUtils.getInt(ntpData, transmitTimestampIndex + 4) & 0xFFFFFFFFL;
            long milliseconds = intPart * 1000L + fractPart * 1000L / 0x100000000L;
            _localOffset = System.currentTimeMillis() - (milliseconds -= 2208988800000L);
            Date networkDateTime = new Date(milliseconds);
            _elapsedTime = System.currentTimeMillis() - start;
            Logger.getGlobal().info(String.format("Network Time successfully retreived: %s in %.3f seconds", networkDateTime.toString(), (double)_elapsedTime / 1000.0));
            _lastNtpTime = networkDateTime;
        }
        catch (Exception ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getGlobal().severe("Error getting network time " + stacktrace);
            _lastNtpTime = null;
        }
    }
}

