/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.beacon.JniorInfo;
import com.integ.beacon.Version;
import com.integ.janoslib.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;

public class JniorItem {
    public static final int BEACON_ASSERT = 1;
    public static final int BEACON_ERRORS = 2;
    public static final int BEACON_MEMERR = 4;
    public static final int BEACON_REFORMAT = 8;
    public static final int BEACON_FLASH = 16;
    public static final int BEACON_DUMP = 32;
    public static final int BEACON_APPERR = 64;
    public static final int BEACON_RESERVED = 128;
    private JniorInfo _jniorInfo;

    public JniorItem(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
    }

    public String getSerialNumberString() {
        return String.valueOf(this._jniorInfo.getSerialNumber());
    }

    public int getSerialNumber() {
        return this._jniorInfo.getSerialNumber();
    }

    public String getModel() {
        return this._jniorInfo.Model;
    }

    public String getHostname() {
        return this._jniorInfo.Hostname;
    }

    public String getIpAddress() {
        return this._jniorInfo.IpAddress;
    }

    public String getSubnetMask() {
        return this._jniorInfo.SubnetMask;
    }

    public String getPhysicalAddress() {
        return this._jniorInfo.PhysicalAddress;
    }

    public Version getOsVersion() {
        return this._jniorInfo.OsVersion;
    }

    public String getLastAnnounced() {
        return this._jniorInfo.LastAnnounced.toString();
    }

    public Date getBootTime() {
        return this._jniorInfo.BootTime;
    }

    public String getMessages() {
        ArrayList<String> messagesArrayList = new ArrayList<String>();
        if (0 != this._jniorInfo.AttentionInfo) {
            if (0 != (this._jniorInfo.AttentionInfo & 1)) {
                messagesArrayList.add("Assertion occurred");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 2)) {
                messagesArrayList.add("Errors file exists");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 4)) {
                messagesArrayList.add("Memory test failed during boot");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 8)) {
                messagesArrayList.add("SRAM was reformatted on boot");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 0x10)) {
                messagesArrayList.add("FLASH file system was not mounted");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 0x20)) {
                messagesArrayList.add("Dump file exists");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 0x40)) {
                messagesArrayList.add("Some applications could not start");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 0x100)) {
                messagesArrayList.add("Getting Network Capture");
            }
        }
        String[] messagesArray = messagesArrayList.toArray(new String[messagesArrayList.size()]);
        String messageString = StringUtils.join(messagesArray, ", ");
        return messageString;
    }

    public JniorInfo getJniorInfo() {
        return this._jniorInfo;
    }

    public void update(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
    }
}

