/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot.menus;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.helpers.IP4Validator;
import com.integ.supporter.snapshot.SnapshotTab;
import com.integ.supporter.ui.dialogs.JniorSelectionDialog;
import com.integ.supporter.ui.dialogs.LoginDialog2;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class SnapshotPopupMenu
extends JMenu {
    private JMenuItem _menuAbortSnapshot;

    public SnapshotPopupMenu() {
        super("Snapshot");
        this.createMenu();
    }

    private void createMenu() {
        super.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                Object component = null;
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenuItem menuTakeSnapshot = new JMenuItem("Take Snapshot");
        menuTakeSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JniorInfo[] selectedJniors;
                JniorSelectionDialog dlg = new JniorSelectionDialog((Frame)SupporterMain.getMainFrame(), true);
                dlg.setVisible(true);
                for (JniorInfo selectedRemoteJniorInfo : selectedJniors = dlg.getSelectedJniors()) {
                    SnapshotTab.getInstance().startSnapshot(selectedRemoteJniorInfo);
                }
                String manuallyEnteredIPAddress = dlg.getManuallyEneteredIPAddress();
                if (IP4Validator.isValid(manuallyEnteredIPAddress)) {
                    JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(SnapshotPopupMenu.this);
                    LoginDialog2 loginDialog = new LoginDialog2((Frame)topFrame, true);
                    loginDialog.setTitle("Snapshot for " + manuallyEnteredIPAddress + " needs credentials");
                    loginDialog.centerParent();
                    loginDialog.setVisible(true);
                    if (loginDialog.getResult() == 1) {
                        JniorInfo jniorInfo = new JniorInfo(0);
                        jniorInfo.IpAddress = manuallyEnteredIPAddress;
                        jniorInfo.Username = loginDialog.getUsername();
                        jniorInfo.Password = loginDialog.getPassword();
                        SnapshotTab.getInstance().startSnapshot(jniorInfo);
                    }
                }
            }
        });
        super.add(menuTakeSnapshot);
        this._menuAbortSnapshot = new JMenuItem("Abort Snapshot");
        this._menuAbortSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object component = null;
            }
        });
        super.add(this._menuAbortSnapshot);
        JMenuItem removeCompleted = new JMenuItem("Remove Completed");
        removeCompleted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SnapshotTab.getInstance().removeCompleted();
                }
                catch (Exception ex) {
                    String stacktrace = ExceptionUtils.getStackTrace(ex);
                    Logger.getGlobal().severe(stacktrace);
                }
            }
        });
        super.add(removeCompleted);
        JMenuItem openSnapshotFolderMenuItem = new JMenuItem("Open Snapshot Folder");
        openSnapshotFolderMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    File directoryToOpen = new File(Constants.SNAPSHOTS_FOLDER);
                    desktop.open(directoryToOpen);
                }
                catch (IOException | IllegalArgumentException ex) {
                    Logger.getLogger(SnapshotPopupMenu.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
                }
            }
        });
        super.add(openSnapshotFolderMenuItem);
    }
}

