/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.toasts;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.ui.toasts.OptionPaneToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class LoginToast
extends OptionPaneToast {
    private final JniorInfo _jniorInfo;
    private final JButton okButton;
    private JPanel credentialsPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPasswordField passwordTextField;
    private JLabel titleLabel;
    private JTextField usernameTextField;

    public LoginToast(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
        this.init();
        super.setModal(true);
        super.setMessage(this.credentialsPanel);
        super.setMessageType(2);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(e1 -> {
            ToastNotifications.getInstance().hide(this);
            this._result = 0;
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e1 -> ToastNotifications.getInstance().hide(this));
        super.setOptions(new JButton[]{this.okButton, cancelButton});
        this.addKeyListeners();
    }

    private void addKeyListeners() {
        this.usernameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    LoginToast.this.passwordTextField.grabFocus();
                }
            }
        });
        this.passwordTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    LoginToast.this.okButton.doClick();
                }
            }
        });
    }

    public String getUsername() {
        return this.usernameTextField.getText();
    }

    public String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    private void init() {
        this.credentialsPanel = new JPanel();
        this.credentialsPanel.setOpaque(false);
        this.titleLabel = new JLabel();
        this.titleLabel.setText(this._jniorInfo.toString() + " needs credentials");
        this.jLabel1 = new JLabel("Username:");
        this.jLabel2 = new JLabel("Password:");
        this.usernameTextField = new JTextField();
        this.passwordTextField = new JPasswordField();
        GroupLayout credentialsPanelLayout = new GroupLayout(this.credentialsPanel);
        this.credentialsPanel.setLayout(credentialsPanelLayout);
        credentialsPanelLayout.setHorizontalGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(credentialsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, credentialsPanelLayout.createSequentialGroup().addContainerGap(21, Short.MAX_VALUE).addGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.usernameTextField).addComponent(this.passwordTextField, -2, 137, -2)).addContainerGap()));
        credentialsPanelLayout.setVerticalGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(credentialsPanelLayout.createSequentialGroup().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usernameTextField, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.passwordTextField, -2, -1, -2)).addGap(0, 23, Short.MAX_VALUE)));
    }
}

