/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.utils;

public class StringUtils {
    public static String[] split(String str, String delim) {
        return StringUtils.split(str, new String[]{delim}, 0);
    }

    public static String[] split(String str, String delim, int index) {
        return StringUtils.split(str, new String[]{delim}, index);
    }

    public static String[] split(String str, String[] delim, int index) {
        if (null == str) {
            return new String[0];
        }
        int startIndex = index;
        int[] delimPosArray = new int[delim.length];
        for (int delimIndex = 0; delimIndex < delimPosArray.length; ++delimIndex) {
            delimPosArray[delimIndex] = str.indexOf(delim[delimIndex]);
        }
        int delimPos = 0;
        int count = 0;
        while (true) {
            int nextDelimIndex = -1;
            int nextDelimPos = Integer.MAX_VALUE;
            for (int delimIndex = 0; delimIndex < delimPosArray.length; ++delimIndex) {
                if (delimPosArray[delimIndex] >= nextDelimPos) continue;
                nextDelimIndex = delimIndex;
                nextDelimPos = delimPosArray[delimIndex];
            }
            if (nextDelimIndex == -1 || (delimPos = str.indexOf(delim[nextDelimIndex], index)) == -1) break;
            ++count;
            index = delimPos + delim[nextDelimIndex].length();
            delimPosArray[nextDelimIndex] = str.indexOf(delim[nextDelimIndex], index);
            if (delimPosArray[nextDelimIndex] == -1) {
                delimPosArray[nextDelimIndex] = str.length();
            }
            if (index != str.length()) continue;
            ++count;
        }
        if (index != str.length()) {
            ++count;
        }
        for (int delimIndex = 0; delimIndex < delimPosArray.length; ++delimIndex) {
            delimPosArray[delimIndex] = str.indexOf(delim[delimIndex]);
        }
        String[] arr = new String[count];
        int i = 0;
        index = startIndex;
        while (true) {
            int nextDelimIndex = -1;
            int nextDelimPos = Integer.MAX_VALUE;
            for (int delimIndex = 0; delimIndex < delimPosArray.length; ++delimIndex) {
                if (delimPosArray[delimIndex] >= nextDelimPos) continue;
                nextDelimIndex = delimIndex;
                nextDelimPos = delimPosArray[delimIndex];
            }
            if (nextDelimIndex == -1 || (delimPos = str.indexOf(delim[nextDelimIndex], index)) == -1) break;
            arr[i++] = str.substring(index, delimPos);
            index = delimPos + delim[nextDelimIndex].length();
            delimPosArray[nextDelimIndex] = str.indexOf(delim[nextDelimIndex], index);
            if (delimPosArray[nextDelimIndex] == -1) {
                delimPosArray[nextDelimIndex] = str.length();
            }
            if (index != str.length()) continue;
            arr[i++] = "";
        }
        if (index != str.length()) {
            arr[i] = str.substring(index);
        }
        return arr;
    }

    public static String join(String[] dataArray, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (String s : dataArray) {
            if (0 < sb.length()) {
                sb.append(delimiter);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String trim(String s, char c) {
        s = StringUtils.trimStart(s, c);
        s = StringUtils.trimEnd(s, c);
        return s;
    }

    public static String trimStart(String s, char c) {
        while (s.charAt(0) == c) {
            s = s.substring(1);
        }
        return s;
    }

    public static String trimEnd(String s, char c) {
        int lastIndexPos;
        for (lastIndexPos = s.length(); 0 < lastIndexPos && s.charAt(lastIndexPos - 1) == c; --lastIndexPos) {
        }
        s = s.substring(0, lastIndexPos);
        return s;
    }

    public static String replaceAll(String original, String target, String replace) {
        StringBuilder sb = new StringBuilder(original.length());
        int pos = 0;
        int lastPos = 0;
        while ((pos = original.indexOf(target, lastPos)) >= 0) {
            sb.append(original.substring(lastPos, pos));
            sb.append(replace);
            lastPos = pos + target.length();
        }
        if (original.length() != lastPos) {
            sb.append(original.substring(lastPos));
        }
        String result = sb.toString();
        return result;
    }

    public static byte[] getEscapedBytes(String string) {
        Object newTermString = "";
        boolean backslashFound = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\' && !backslashFound) {
                backslashFound = true;
                continue;
            }
            if (backslashFound) {
                switch (string.charAt(i)) {
                    case 'r': {
                        newTermString = (String)newTermString + "\r";
                        break;
                    }
                    case 'n': {
                        newTermString = (String)newTermString + "\n";
                        break;
                    }
                    case 't': {
                        newTermString = (String)newTermString + "\t";
                        break;
                    }
                    case 'f': {
                        newTermString = (String)newTermString + "\f";
                        break;
                    }
                    case 'b': {
                        newTermString = (String)newTermString + "\b";
                        break;
                    }
                    case '0': {
                        newTermString = (String)newTermString + "\u0000";
                        break;
                    }
                    case '\"': {
                        newTermString = (String)newTermString + "\"";
                        break;
                    }
                    case 'x': {
                        String s = string.substring(i + 1, i + 3);
                        newTermString = (String)newTermString + (char)Integer.parseInt(s, 16);
                        i += 2;
                    }
                }
            } else {
                newTermString = (String)newTermString + string.charAt(i);
            }
            backslashFound = false;
        }
        return ((String)newTermString).getBytes();
    }

    public static boolean isNullOrEmpty(String s) {
        return null == s || "".equals(s);
    }
}

