/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.menus;

import com.integ.supporter.config.BeaconConfig;
import com.integ.supporter.config.GeneralConfig;
import com.integ.supporter.ui.menus.MainMenu;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class OptionsMenu
extends JMenu {
    private final JMenu _generalMenu = new JMenu("General");
    private final JMenu _beaconMenu = new JMenu("Beacon");

    public OptionsMenu() {
        super("Options");
        this.initMenu();
    }

    private void initMenu() {
        this.addBeaconMenu();
        super.addSeparator();
        this.addGeneralMenu();
    }

    private void addGeneralMenu() {
        this.showIconsInMenuMenuItem();
        this.showIconsWithTextMenuItem();
        this.showCinemaMenuItem();
    }

    private void showIconsInMenuMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Show Icons in Main Menu", true);
        menuItem.setState(GeneralConfig.getMainMenuUseIcons());
        menuItem.addActionListener(evt -> {
            MainMenu.MENU_LOGGER.info(String.format("user selected %s", evt.getActionCommand()));
            GeneralConfig.setMainMenuUseIcons(menuItem.getState());
        });
        super.add(menuItem);
    }

    private void showIconsWithTextMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Show Text with Icons", true);
        menuItem.setState(GeneralConfig.getIconsWithText());
        menuItem.addActionListener(evt -> {
            MainMenu.MENU_LOGGER.info(String.format("user selected %s", evt.getActionCommand()));
            GeneralConfig.setIconsWithText(menuItem.getState());
        });
        super.add(menuItem);
    }

    private void showCinemaMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Show Cinema Dropdown in Main Menu", true);
        menuItem.setState(GeneralConfig.getShowCinemaInMainMenu());
        menuItem.addActionListener(evt -> {
            MainMenu.MENU_LOGGER.info(String.format("user selected %s", evt.getActionCommand()));
            boolean state = menuItem.getState();
            GeneralConfig.setShowCinemaInMainMenu(state);
        });
        super.add(menuItem);
    }

    private void addBeaconMenu() {
        super.add(this._beaconMenu);
        this.showFullOsVersionMenuItem();
        this.doubleClickLaunchesTelnetMenuItem();
    }

    private void showFullOsVersionMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Show Full OS Version", true);
        menuItem.setState(GeneralConfig.getShowFullOsVersion());
        menuItem.addActionListener(evt -> {
            MainMenu.MENU_LOGGER.info(String.format("user selected %s", evt.getActionCommand()));
            GeneralConfig.setShowFullOsVersion(menuItem.getState());
        });
        this._beaconMenu.add(menuItem);
    }

    private void doubleClickLaunchesTelnetMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Double Click Opens Console", true);
        menuItem.setState(BeaconConfig.getDoubleClickOpensConsoleSession());
        menuItem.addActionListener(evt -> {
            MainMenu.MENU_LOGGER.info(String.format("user selected %s", evt.getActionCommand()));
            BeaconConfig.setDoubleClickOpensConsoleSession(menuItem.getState());
        });
        this._beaconMenu.add(menuItem);
    }
}

