/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.ThreadUtils;
import com.integ.supporter.DetailsFileChooser;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.dialogs.JniorSelectionDialog;
import com.integ.supporter.updater.OpenedUpdateProjects;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.UpdateProjectTab;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class UpdateProjectMainMenu
extends JMenu {
    private JMenuItem _menuCloseUpdateProject;
    private JMenuItem _menuPublishUpdateProject;
    private JMenuItem _menuAbortUpdateProject;

    public UpdateProjectMainMenu() {
        super("Update Project");
        this.createMenu();
    }

    private void createMenu() {
        super.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                Object component = null;
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.addCreateNewUpdateProject();
        this.addOpenUpdateProject();
        this.addOpenSnapshotUpdateProject();
        this.addCloseUpdateProject();
        this.addPublishUpdateProject();
        this.addAbortUpdateProject();
    }

    private void addCreateNewUpdateProject() {
        JMenuItem menuNewUpdateProject = new JMenuItem("Create New Update Project");
        menuNewUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SupporterMain.getMainFrame().showUpdatesPane();
                    UpdateProjectFile updateProjectFile = new UpdateProjectFile();
                    updateProjectFile.setTitle("New Update Project");
                    OpenedUpdateProjects.getInstance().add(updateProjectFile);
                }
                catch (Exception ex) {
                    String stacktrace = ExceptionUtils.getStackTrace(ex);
                    Logger.getGlobal().severe(stacktrace);
                    NotificationCollection.addError(ex);
                }
            }
        });
        super.add(menuNewUpdateProject);
    }

    private void addOpenUpdateProject() {
        JMenuItem menuOpenUpdateProject = new JMenuItem("Open Update Project");
        menuOpenUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final DetailsFileChooser fileChooser = new DetailsFileChooser();
                fileChooser.setCurrentDirectory(new File(UpdateProjectTab.UPDATE_PROJECTS_DIRECTORY));
                fileChooser.setFileSelectionMode(0);
                fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("JNIOR Update Project", "zip"));
                fileChooser.setAcceptAllFileFilterUsed(true);
                int result = fileChooser.showOpenDialog(UpdateProjectMainMenu.this.getRootPane());
                if (result == 0) {
                    ThreadUtils.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                File selectedFile = fileChooser.getSelectedFile();
                                UpdateProjectFile updateProjectFile = new UpdateProjectFile(selectedFile);
                                updateProjectFile.load();
                            }
                            catch (IOException ex) {
                                String stacktrace = ExceptionUtils.getStackTrace(ex);
                                Logger.getGlobal().severe(stacktrace);
                            }
                        }
                    });
                }
            }
        });
        super.add(menuOpenUpdateProject);
    }

    private void addOpenSnapshotUpdateProject() {
        JMenuItem menuSnapshotOpenUpdateProject = new JMenuItem("Open Snapshot Update Project");
        menuSnapshotOpenUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailsFileChooser fileChooser = new DetailsFileChooser();
                fileChooser.setCurrentDirectory(new File(UpdateProjectTab.UPDATE_PROJECTS_DIRECTORY));
                fileChooser.setFileSelectionMode(0);
                fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("JNIOR Update Project", "zip"));
                fileChooser.setAcceptAllFileFilterUsed(true);
                int result = fileChooser.showOpenDialog(UpdateProjectMainMenu.this.getRootPane());
                if (result == 0) {
                    try {
                        File selectedFile = fileChooser.getSelectedFile();
                        UpdateProjectFile updateProjectFile = new UpdateProjectFile(selectedFile);
                        updateProjectFile.load();
                    }
                    catch (IOException ex) {
                        String stacktrace = ExceptionUtils.getStackTrace(ex);
                        Logger.getGlobal().severe(stacktrace);
                    }
                }
            }
        });
        super.add(menuSnapshotOpenUpdateProject);
    }

    private void addCloseUpdateProject() {
        this._menuCloseUpdateProject = new JMenuItem("Close Update Project");
        this._menuCloseUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object component = null;
            }
        });
        this._menuCloseUpdateProject.setEnabled(false);
        super.add(this._menuCloseUpdateProject);
    }

    private void addPublishUpdateProject() {
        this._menuPublishUpdateProject = new JMenuItem("Publish Update Project");
        this._menuPublishUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object component = null;
                JniorSelectionDialog dlg = new JniorSelectionDialog((Frame)SupporterMain.getMainFrame(), true);
                dlg.setVisible(true);
                JniorInfo[] selectedJniors = dlg.getSelectedJniors();
            }
        });
        super.add(this._menuPublishUpdateProject);
    }

    private void addAbortUpdateProject() {
        this._menuAbortUpdateProject = new JMenuItem("Abort Update Project");
        this._menuAbortUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object component = null;
            }
        });
        this._menuAbortUpdateProject.setEnabled(false);
        super.add(this._menuAbortUpdateProject);
    }
}

