/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot.menus;

import com.integ.supporter.snapshot.JniorSnapshotTab;
import com.integ.supporter.snapshot.SnapshotTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SnapshotTabsPopupMenu
extends JPopupMenu {
    private final JMenuItem _abortMenuItem = new JMenuItem("Abort");
    private final JMenuItem _removeTabMenuItem = new JMenuItem("Remove Tab");

    public SnapshotTabsPopupMenu() {
        this.init();
    }

    private final void init() {
        super.setMinimumSize(new Dimension(200, 1));
        super.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                System.out.println(String.format("%s popup will become visible", this.getClass().getName()));
                SnapshotTab snapshotTab = SnapshotTab.getInstance();
                JniorSnapshotTab selectedSnapshotTab = snapshotTab.getSelectedSnapshotTab();
                if (null != selectedSnapshotTab) {
                    boolean removeTabAllowed = null != selectedSnapshotTab && selectedSnapshotTab.isComplete();
                    SnapshotTabsPopupMenu.this._abortMenuItem.setEnabled(!removeTabAllowed);
                    SnapshotTabsPopupMenu.this._removeTabMenuItem.setEnabled(removeTabAllowed);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.createAbortMenuItem();
        this.createRemoveTabeMenuItem();
    }

    private void createAbortMenuItem() {
        this._abortMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotTab snapshotTab = SnapshotTab.getInstance();
                JniorSnapshotTab jniorSnapshotTab = snapshotTab.getSelectedSnapshotTab();
                if (null != jniorSnapshotTab) {
                    jniorSnapshotTab.abort();
                }
            }
        });
        super.add(this._abortMenuItem);
    }

    private void createRemoveTabeMenuItem() {
        this._removeTabMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotTab snapshotTab = SnapshotTab.getInstance();
                Component selectedTabComponent = snapshotTab.getTabbedPane().getSelectedComponent();
                snapshotTab.getTabbedPane().remove(selectedTabComponent);
            }
        });
        super.add(this._removeTabMenuItem);
    }
}

