/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.ResourceUtils;
import com.integ.janoslib.utils.StringUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

public class ExecuteEmbeddedJar {
    private static final Logger LOGGER = Logger.getGlobal();

    public void execute(String jarApplicationName, String[] args) {
        try {
            LOGGER.info(String.format("is windows: %s", Boolean.toString(Constants.IS_WINDOWS)));
            File tempJavaApplicationFile = new File(Constants.TEMP_DIRECTORY + File.separator + "Embedded-" + (int)(Math.random() * 100.0) + ".jar");
            File javaApplicationFile = new File(Constants.TEMP_DIRECTORY + File.separator + jarApplicationName);
            LOGGER.info(String.format("%s exists: %s", javaApplicationFile, String.valueOf(javaApplicationFile.exists())));
            if (!javaApplicationFile.exists()) {
                LOGGER.info(String.format("extracting %s", tempJavaApplicationFile));
                ResourceUtils.extractResource("/resources/" + jarApplicationName, tempJavaApplicationFile);
                LOGGER.info(String.format("extracted %s", tempJavaApplicationFile));
            }
            ArrayList<String> cmdArrayList = new ArrayList<String>();
            String javaHome = System.getProperty("java.home");
            if (0 < args.length) {
                Collections.addAll(cmdArrayList, "java", "-jar", "\"" + tempJavaApplicationFile.getPath() + "\"");
                for (String arg : args) {
                    cmdArrayList.add(arg);
                }
            }
            String[] cmdArray = cmdArrayList.toArray(new String[cmdArrayList.size()]);
            LOGGER.info(String.format("%s", StringUtils.join(cmdArray, " ")));
            String commandString = StringUtils.join(cmdArray, " ");
            ProcessBuilder processBuilder = new ProcessBuilder(commandString);
            processBuilder.inheritIO();
            Map<String, String> environment = processBuilder.environment();
            environment.put("JAVA_HOME", javaHome);
            System.out.println(environment.get("JAVA_HOME"));
            processBuilder.command(cmdArray).start();
            LOGGER.info(String.format("executing %s", tempJavaApplicationFile));
        }
        catch (Exception ex) {
            LOGGER.severe(ExceptionUtils.getStackTrace(ex));
            NotificationCollection.addError("Error opening " + jarApplicationName, ex);
        }
    }
}

