/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ActionResult {
    private final ArrayList<ChangeListener> _progressListeners = new ArrayList();
    private Status _status = Status.Waiting;
    private String _abortReason;
    private String _failedMessage;
    private Exception _exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressUpdateListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = this._progressListeners;
        synchronized (arrayList) {
            this._progressListeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChangeListeners() {
        ArrayList<ChangeListener> arrayList = this._progressListeners;
        synchronized (arrayList) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this._progressListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    private void updateStatus(Status newStatus) {
        if (newStatus != this._status) {
            this._status = newStatus;
            this.updateChangeListeners();
        }
    }

    public Status getStatus() {
        return this._status;
    }

    public void start() {
        this._status = Status.InProgress;
        this.updateChangeListeners();
    }

    public boolean isInProgress() {
        return Status.InProgress == this._status;
    }

    public boolean hasCompleted() {
        return Status.InProgress.ordinal() < this._status.ordinal();
    }

    public void complete() {
        if (Status.Waiting == this._status || Status.InProgress == this._status) {
            this.updateStatus(Status.Success);
        }
    }

    public boolean wasSuccessful() {
        return Status.Success == this._status;
    }

    public void abort() {
        this.abort(null);
    }

    public void abort(String abortReason) {
        this.updateStatus(Status.Aborted);
        this._abortReason = abortReason;
    }

    public boolean wasAborted() {
        return Status.Aborted == this._status;
    }

    public String getAbortReason() {
        return this._abortReason;
    }

    public void fail(String message) {
        this.fail(message, null);
    }

    public void fail(String message, Exception ex) {
        this.updateStatus(Status.Failed);
        this._failedMessage = message;
        this._exception = ex;
    }

    public boolean hasFailed() {
        return Status.Failed == this._status;
    }

    public String getFailedMessage() {
        return this._failedMessage;
    }

    public Exception getError() {
        return this._exception;
    }

    public static enum Status {
        Waiting,
        InProgress,
        Success,
        Aborted,
        Failed;

    }
}

