/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.toasts;

import com.integ.supporter.ui.toasts.CubicOutEasing;
import com.integ.supporter.ui.toasts.Easing;
import com.integ.supporter.ui.toasts.ToastAnimation;
import java.awt.Point;
import javax.swing.JWindow;

public class ToastMoveAnimation
extends ToastAnimation {
    private final Point _startLocation;
    private Point _destinationLocation;
    private int _deltaX;
    private int _deltaY;
    private final Easing _easing;

    public ToastMoveAnimation(JWindow window, Point newLocation, int duration) {
        this(window, newLocation, duration, new CubicOutEasing());
    }

    public ToastMoveAnimation(JWindow window, Point destinationLocation, int duration, Easing easing) {
        super(window, duration);
        this._startLocation = window.getLocation();
        this._destinationLocation = destinationLocation;
        this._deltaX = this._destinationLocation.x - this._startLocation.x;
        this._deltaY = this._destinationLocation.y - this._startLocation.y;
        this._easing = easing;
    }

    public Point getDestination() {
        return this._destinationLocation;
    }

    public void setDestination(Point newDestinationLocation) {
        this._destinationLocation = newDestinationLocation;
        this._deltaX = this._destinationLocation.x - this._startLocation.x;
        this._deltaY = this._destinationLocation.y - this._startLocation.y;
    }

    @Override
    protected void update() {
        long timeDelta = System.currentTimeMillis() - this._start;
        if (timeDelta > (long)this._duration) {
            timeDelta = this._duration;
        }
        double x = this._easing.ease(timeDelta, this._startLocation.x, this._deltaX, this._duration);
        double y = this._easing.ease(timeDelta, this._startLocation.y, this._deltaY, this._duration);
        this._toastWindow.setLocation((int)x, (int)y);
        double timePercentage = (double)timeDelta / (double)this._duration;
        if (1.0 <= timePercentage) {
            this.done();
        }
    }
}

