/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.backup;

import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.janoslib.utils.PathUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.backup.DownloadLogic;
import com.integ.supporter.backup.DownloadLogicFactory;
import com.integ.supporter.backup.IgnoreDownloadLogic;
import com.integ.supporter.backup.OverwriteDownloadLogic;
import java.io.File;
import java.security.MessageDigest;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileHistory {
    public static synchronized void fileDownloaded(int serialNumber, File localFile, String remoteFilePath) {
        try {
            DownloadLogic downloadLogic;
            boolean addToFileHistory;
            JSONObject fileJson;
            JSONArray versionJsonArray;
            String jsonFilePath = PathUtils.combine(Constants.BACKUP_DIRECTORY, String.valueOf(serialNumber), "file_history.json");
            String jsonFileContents = new File(jsonFilePath).exists() ? FileUtils.readAllText(jsonFilePath) : "{}";
            JSONObject backupJson = new JSONObject(jsonFileContents);
            if (!backupJson.has(remoteFilePath)) {
                backupJson.put(remoteFilePath, new JSONObject());
            }
            if (null == (versionJsonArray = (fileJson = backupJson.getJSONObject(remoteFilePath)).optJSONArray("versions"))) {
                versionJsonArray = new JSONArray();
            }
            JSONObject downloadedFileJson = new JSONObject();
            downloadedFileJson.put("path", remoteFilePath);
            downloadedFileJson.put("length", localFile.length());
            downloadedFileJson.put("date", localFile.lastModified() / 1000L);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] downloadedFileBytes = FileUtils.readAllBytes(localFile.getPath());
            md.update(downloadedFileBytes);
            byte[] digest = md.digest();
            String md5String = HexUtils.bytesToHex(digest).toLowerCase();
            downloadedFileJson.put("md5", md5String);
            boolean bl = addToFileHistory = 0 == versionJsonArray.length();
            if (!addToFileHistory) {
                JSONObject lastVersion = versionJsonArray.getJSONObject(versionJsonArray.length() - 1);
                boolean bl2 = addToFileHistory = !md5String.equalsIgnoreCase(lastVersion.getString("md5"));
            }
            if (null != (downloadLogic = DownloadLogicFactory.get(downloadedFileJson)) && !(downloadLogic instanceof IgnoreDownloadLogic) && !(downloadLogic instanceof OverwriteDownloadLogic) && addToFileHistory) {
                downloadLogic.setJniorSerialNumber(serialNumber);
                System.out.println("downloadLogic = " + downloadLogic);
                File downloadedFile = downloadLogic.saveFileAs(downloadedFileBytes);
                String relativeLocalPath = downloadedFile.getPath();
                relativeLocalPath = relativeLocalPath.substring(Constants.BACKUP_DIRECTORY.length());
                downloadedFileJson.put("localPath", relativeLocalPath);
                downloadedFileJson.remove("path");
                versionJsonArray.put(downloadedFileJson);
                fileJson.put("versions", versionJsonArray);
                try {
                    jsonFileContents = backupJson.toString(2);
                    FileUtils.writeAllBytes(jsonFilePath, jsonFileContents.getBytes());
                }
                catch (Exception ex) {
                    String errorMessage = String.format("Error saving backup json '%s'", jsonFilePath);
                    NotificationCollection.addError(errorMessage, ex);
                }
            }
        }
        catch (Exception ex) {
            String errorMessage = String.format("Error adding '%s' to backups for '%d'", remoteFilePath, serialNumber);
            NotificationCollection.addError(errorMessage, ex);
        }
    }
}

