/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.utils;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFFER_SIZE = 4096;

    private ZipUtils() {
    }

    public static boolean isEmpty(String zipFilePath) {
        return ZipUtils.isEmpty(new File(zipFilePath));
    }

    public static boolean isEmpty(File zipFile) {
        return !zipFile.exists() || 0L == zipFile.length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteEntry(String zipFilePath, String entryPath) throws IOException {
        ZipFile zipFile = null;
        InputStream zipInputStream = null;
        DeflaterOutputStream zipOutputStream = null;
        boolean success = true;
        try {
            zipFile = new ZipFile(zipFilePath);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFilePath + ".tmp"));
            Enumeration<? extends ZipEntry> zipEnumeration = zipFile.entries();
            while (zipEnumeration.hasMoreElements()) {
                ZipEntry zipEntry = zipEnumeration.nextElement();
                if (entryPath.equals(zipEntry.getName())) continue;
                try {
                    zipInputStream = zipFile.getInputStream(zipEntry);
                    byte[] contents = ZipUtils.getEntryBytes(zipInputStream);
                    ((ZipOutputStream)zipOutputStream).putNextEntry(new ZipEntry(zipEntry.getName()));
                    zipOutputStream.write(contents);
                    ((ZipOutputStream)zipOutputStream).closeEntry();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new RuntimeException("error copying " + zipEntry.getName() + " entry", ex);
                    return;
                }
            }
        }
        catch (Exception ex) {
            success = false;
            ex.printStackTrace();
            throw ex;
        }
        finally {
            try {
                if (null != zipOutputStream) {
                    zipOutputStream.flush();
                    ((ZipOutputStream)zipOutputStream).close();
                }
                if (null != zipFile) {
                    zipFile.close();
                }
                if (success) {
                    File destFile = new File(zipFilePath);
                    destFile.delete();
                    new File(zipFilePath + ".tmp").renameTo(destFile);
                }
            }
            catch (IOException ex) {
                Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
                throw ex;
            }
        }
    }

    public static void addFile(String zipFilePath, String filePath, String parentDirectory) throws IOException {
        if (null != parentDirectory && !"".equals(parentDirectory) && !((String)parentDirectory).endsWith("/")) {
            parentDirectory = (String)parentDirectory + "/";
        }
        File file = new File(filePath);
        String entryPath = (String)parentDirectory + file.getName();
        ZipFile zipFile = null;
        InputStream zipInputStream = null;
        DeflaterOutputStream zipOutputStream = null;
        boolean success = true;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFilePath + ".tmp"));
            if (new File(zipFilePath).exists() && 0L != new File(zipFilePath).length()) {
                zipFile = new ZipFile(zipFilePath);
                Enumeration<? extends ZipEntry> zipEnumeration = zipFile.entries();
                while (zipEnumeration.hasMoreElements()) {
                    ZipEntry zipEntry = zipEnumeration.nextElement();
                    if (entryPath.equals(zipEntry.getName())) continue;
                    try {
                        zipInputStream = zipFile.getInputStream(zipEntry);
                        byte[] contents = ZipUtils.getEntryBytes(zipInputStream);
                        ZipEntry zipEntryClone = new ZipEntry(zipEntry.getName());
                        zipEntryClone.setTime(zipEntry.getTime());
                        ((ZipOutputStream)zipOutputStream).putNextEntry(zipEntryClone);
                        zipOutputStream.write(contents);
                        ((ZipOutputStream)zipOutputStream).closeEntry();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new RuntimeException("error copying " + zipEntry.getName() + " entry", ex);
                    }
                }
            }
            ZipEntry zipEntry = new ZipEntry(entryPath);
            long fileTime = file.lastModified();
            zipEntry.setTime(fileTime);
            ((ZipOutputStream)zipOutputStream).putNextEntry(zipEntry);
            zipOutputStream.write(FileUtils.readAllBytes(filePath));
        }
        catch (Exception ex) {
            success = false;
            ex.printStackTrace();
            throw ex;
        }
        finally {
            try {
                if (null != zipOutputStream) {
                    zipOutputStream.flush();
                    ((ZipOutputStream)zipOutputStream).close();
                }
                if (null != zipFile) {
                    zipFile.close();
                }
                if (success) {
                    File destFile = new File(zipFilePath);
                    destFile.delete();
                    new File(zipFilePath + ".tmp").renameTo(destFile);
                }
            }
            catch (IOException ex) {
                Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
                throw ex;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void renameEntry(String zipFilePath, String oldEntryPath, String newEntryPath) throws IOException {
        if (ZipUtils.isEmpty(zipFilePath)) {
            return;
        }
        ZipFile zipFile = null;
        InputStream zipInputStream = null;
        DeflaterOutputStream zipOutputStream = null;
        boolean success = true;
        try {
            zipFile = new ZipFile(zipFilePath);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFilePath + ".tmp"));
            Enumeration<? extends ZipEntry> zipEnumeration = zipFile.entries();
            while (zipEnumeration.hasMoreElements()) {
                ZipEntry zipEntry = zipEnumeration.nextElement();
                String entryName = zipEntry.getName();
                if (entryName.equals(oldEntryPath)) {
                    entryName = newEntryPath;
                }
                try {
                    zipInputStream = zipFile.getInputStream(zipEntry);
                    byte[] contents = ZipUtils.getEntryBytes(zipInputStream);
                    ZipEntry zipEntryClone = new ZipEntry(entryName);
                    if (null == zipEntry.getCreationTime()) {
                        zipEntry.setCreationTime(zipEntry.getLastModifiedTime());
                    }
                    zipEntryClone.setCreationTime(zipEntry.getCreationTime());
                    zipEntryClone.setLastModifiedTime(zipEntry.getLastModifiedTime());
                    ((ZipOutputStream)zipOutputStream).putNextEntry(zipEntryClone);
                    zipOutputStream.write(contents);
                    ((ZipOutputStream)zipOutputStream).closeEntry();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new RuntimeException("error copying " + zipEntry.getName() + " entry", ex);
                    return;
                }
            }
        }
        catch (Exception ex) {
            success = false;
            ex.printStackTrace();
            throw ex;
        }
        finally {
            try {
                if (null != zipOutputStream) {
                    zipOutputStream.flush();
                    ((ZipOutputStream)zipOutputStream).close();
                }
                if (null != zipFile) {
                    zipFile.close();
                }
                if (success) {
                    File destFile = new File(zipFilePath);
                    destFile.delete();
                    new File(zipFilePath + ".tmp").renameTo(destFile);
                }
            }
            catch (IOException ex) {
                Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
                throw ex;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void renameDirectoryEntries(String zipFilePath, String oldDirectoryEntryName, String newDirectoryEntryName) throws IOException {
        if (ZipUtils.isEmpty(zipFilePath)) {
            return;
        }
        ZipFile zipFile = null;
        InputStream zipInputStream = null;
        DeflaterOutputStream zipOutputStream = null;
        boolean success = true;
        try {
            zipFile = new ZipFile(zipFilePath);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFilePath + ".tmp"));
            Enumeration<? extends ZipEntry> zipEnumeration = zipFile.entries();
            while (zipEnumeration.hasMoreElements()) {
                ZipEntry zipEntry = zipEnumeration.nextElement();
                Object entryName = zipEntry.getName();
                if (((String)entryName).startsWith(oldDirectoryEntryName + "/")) {
                    entryName = newDirectoryEntryName + ((String)entryName).substring(oldDirectoryEntryName.length());
                }
                try {
                    zipInputStream = zipFile.getInputStream(zipEntry);
                    byte[] contents = ZipUtils.getEntryBytes(zipInputStream);
                    ZipEntry zipEntryClone = new ZipEntry((String)entryName);
                    if (null == zipEntry.getCreationTime()) {
                        zipEntry.setCreationTime(zipEntry.getLastModifiedTime());
                    }
                    zipEntryClone.setCreationTime(zipEntry.getCreationTime());
                    zipEntryClone.setLastModifiedTime(zipEntry.getLastModifiedTime());
                    ((ZipOutputStream)zipOutputStream).putNextEntry(zipEntryClone);
                    zipOutputStream.write(contents);
                    ((ZipOutputStream)zipOutputStream).closeEntry();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new RuntimeException("error copying " + zipEntry.getName() + " entry", ex);
                    return;
                }
            }
        }
        catch (Exception ex) {
            success = false;
            ex.printStackTrace();
            throw ex;
        }
        finally {
            try {
                if (null != zipOutputStream) {
                    zipOutputStream.flush();
                    ((ZipOutputStream)zipOutputStream).close();
                }
                if (null != zipFile) {
                    zipFile.close();
                }
                if (success) {
                    File destFile = new File(zipFilePath);
                    destFile.delete();
                    new File(zipFilePath + ".tmp").renameTo(destFile);
                }
            }
            catch (IOException ex) {
                Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
                throw ex;
            }
        }
    }

    public static void zip(List<File> listFiles, String destZipFile) throws FileNotFoundException, IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destZipFile));
        for (File file : listFiles) {
            if (file.isDirectory()) {
                ZipUtils.zipDirectory(file, file.getName(), zos);
                continue;
            }
            ZipUtils.zipFile(file, zos);
        }
        zos.flush();
        zos.close();
    }

    public static void zip(String[] files, String destZipFile) throws FileNotFoundException, IOException {
        ArrayList<File> listFiles = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            listFiles.add(new File(files[i]));
        }
        ZipUtils.zip(listFiles, destZipFile);
    }

    private static void zipDirectory(File folder, String parentFolder, ZipOutputStream zos) throws FileNotFoundException, IOException {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                ZipUtils.zipDirectory(file, parentFolder + "/" + file.getName(), zos);
                continue;
            }
            ZipEntry zipEntry = new ZipEntry(parentFolder + "/" + file.getName());
            long fileTime = file.lastModified();
            zipEntry.setTime(fileTime);
            zos.putNextEntry(zipEntry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = bis.read(bytesIn)) != -1) {
                zos.write(bytesIn, 0, read);
            }
            bis.close();
            zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        ZipEntry zipEntry = new ZipEntry(file.getName());
        long fileTime = file.lastModified();
        zipEntry.setTime(fileTime);
        zos.putNextEntry(zipEntry);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = bis.read(bytesIn)) != -1) {
                zos.write(bytesIn, 0, read);
            }
        }
        zos.closeEntry();
    }

    public static boolean findEntry(String zipFilePath, String entryName) throws IOException {
        return null != ZipUtils.getEntry(zipFilePath, Pattern.compile("^" + entryName, 2));
    }

    public static boolean findEntry(String zipFilePath, Pattern pattern) throws IOException {
        return null != ZipUtils.getEntry(zipFilePath, pattern);
    }

    public static ZipEntry getEntry(String zipFilePath, String entryName) throws IOException {
        return ZipUtils.getEntry(zipFilePath, Pattern.compile("^" + entryName, 2));
    }

    public static ZipEntry getEntry(String zipFilePath, Pattern pattern) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> zipEnumeration = zipFile.entries();
            while (zipEnumeration.hasMoreElements()) {
                ZipEntry zipEntry = zipEnumeration.nextElement();
                if (!pattern.matcher(zipEntry.getName()).find()) continue;
                ZipEntry zipEntry2 = zipEntry;
                return zipEntry2;
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (null != zipFile) {
                    zipFile.close();
                }
            }
            catch (IOException ex) {
                Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
            }
        }
        return null;
    }

    public static byte[] extractEntry(String zipFilePath, String entryName) throws IOException {
        ZipFile zipFile = null;
        InputStream zipInputStream = null;
        try {
            zipFile = new ZipFile(zipFilePath);
            ZipEntry zipEntry = ZipUtils.getEntry(zipFilePath, entryName);
            if (null != zipEntry) {
                byte[] contents;
                System.out.println("zipEntry.getName() = " + zipEntry.getName());
                zipInputStream = zipFile.getInputStream(zipEntry);
                byte[] byArray = contents = ZipUtils.getEntryBytes(zipInputStream);
                return byArray;
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (null != zipInputStream) {
                    zipInputStream.close();
                }
                if (null != zipFile) {
                    zipFile.close();
                }
            }
            catch (IOException ex) {
                Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
            }
        }
        return null;
    }

    public static byte[] getEntryBytes(InputStream zipInputStream) throws IOException {
        int len;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = zipInputStream.read(buffer)) > 0) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

