/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.BackgroundAction;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.dialogs.LoginDialog;
import java.awt.Frame;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public abstract class RemoteCinemaFile
extends BackgroundAction {
    protected FTPClient _ftpClient;
    private String _title;

    public RemoteCinemaFile(JniorInfo jniorInfo) {
        super(jniorInfo);
    }

    @Override
    public String getTitle() {
        return String.format("%s for %s", this._title, super.getJniorInfo().IpAddress);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @Override
    public abstract void run();

    protected boolean createFtpClient() throws IOException, InterruptedException {
        this._ftpClient = new FTPClient();
        this._ftpClient.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out)));
        try {
            super.update("Connecting to FTP Server");
            this._ftpClient.setConnectTimeout(5000);
            this._ftpClient.connect(super.getJniorInfo().IpAddress, 21);
            int reply = this._ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                throw new ConnectException("Error connecting to FTP Server");
            }
        }
        catch (ConnectException | SocketTimeoutException ex) {
            if (null != this._ftpClient) {
                this._ftpClient.disconnect();
            }
            super.getResult().fail("Error connecting to FTP Server");
            super.update("Error connecting to FTP Server");
            return false;
        }
        for (int i = 2; i >= 0; --i) {
            super.update("Logging in to FTP Server");
            if (this._ftpClient.login(super.getJniorInfo().Username, super.getJniorInfo().Password)) break;
            if (0 == i) {
                super.getResult().fail("Error logging in to FTP server");
                super.update("Error logging in to FTP server");
                return false;
            }
            LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
            loginDialog.setDescription("Get credentials for " + this.getJniorInfo().IpAddress);
            loginDialog.centerParent();
            loginDialog.setVisible(true);
            if (loginDialog.getResult() != 1) {
                super.getResult().abort("User cancelled providing new credentials");
                super.update("User cancelled providing new credentials");
                return false;
            }
            this.getJniorInfo().Username = loginDialog.getUsername();
            this.getJniorInfo().Password = loginDialog.getPassword();
        }
        return true;
    }
}

