/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.net.LoginFailedException;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.protocols.jmpprotocol.helpers.FileListing;
import com.integ.supporter.JniorControlConnectionAuthenticationListener;
import com.integ.supporter.JniorControlConnectionAuthenticationNotifier;
import com.integ.supporter.JniorControlConnectionListener;
import com.integ.supporter.JniorControlConnectionNotifier;
import com.integ.supporter.JniorSeries3ControlConnection;
import com.integ.supporter.JniorSeries4ControlConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JniorControlConnection {
    protected JniorControlConnection _this;
    protected boolean _abort;
    protected final JniorInfo _targetJniorInfo;
    protected final Logger _logger;
    protected final JniorControlConnectionNotifier _connectionNotifier = new JniorControlConnectionNotifier();
    protected final JniorControlConnectionAuthenticationNotifier _authenticationNotifier = new JniorControlConnectionAuthenticationNotifier();

    public static JniorControlConnection getFor(JniorInfo targetJniorInfo, Logger logger) {
        JniorSeries3ControlConnection jniorControlConnection = null;
        if (4 == targetJniorInfo.getSeries() || 0 == targetJniorInfo.getSerialNumber()) {
            jniorControlConnection = new JniorSeries4ControlConnection(targetJniorInfo, logger);
        } else if (3 == targetJniorInfo.getSeries()) {
            jniorControlConnection = new JniorSeries3ControlConnection(targetJniorInfo, logger);
        }
        logger.info("control connection is open");
        return jniorControlConnection;
    }

    protected JniorControlConnection(JniorInfo targetJniorInfo, Logger logger) {
        this._targetJniorInfo = targetJniorInfo;
        this._logger = logger;
        this._this = this;
    }

    public JniorInfo getJniorInfo() {
        return this._targetJniorInfo;
    }

    public void addConnectionListener(JniorControlConnectionListener listener) {
        this._connectionNotifier.addEventListener(listener);
    }

    public void addAuthenticationListener(JniorControlConnectionAuthenticationListener listener) {
        this._authenticationNotifier.addEventListener(listener);
    }

    public boolean init() {
        boolean connected = this.connect();
        if (connected) {
            try {
                String serialNumberResponse = this.exec("registry $SerialNumber");
                try {
                    Pattern pattern = Pattern.compile("= (?<serial>\\d{9})");
                    Matcher matcher = pattern.matcher(serialNumberResponse);
                    if (matcher.find()) {
                        this._targetJniorInfo.setSerialNumber(Integer.valueOf(matcher.group("serial")));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Logger.getLogger(JniorControlConnection.class.getName()).log(Level.SEVERE, null, ex);
                }
                String hostname = this.exec("registry IpConfig/HostName");
                this._targetJniorInfo.Hostname = hostname = hostname.substring(hostname.indexOf(" = ") + 3);
            }
            catch (Exception ex) {
                try {
                    this.disconnect();
                }
                catch (IOException ex1) {
                    ex.printStackTrace();
                }
                connected = false;
            }
        }
        return connected;
    }

    public abstract boolean isCommandConnectionConnected();

    public abstract boolean connect();

    public abstract boolean connect(boolean var1);

    public abstract void disconnect() throws IOException;

    public void abort() {
        this._abort = true;
    }

    public abstract boolean isLoggedIn();

    public int getUnitSerialNumber() {
        try {
            if (0 != this._targetJniorInfo.getSerialNumber()) {
                return this._targetJniorInfo.getSerialNumber();
            }
            String serialNumberResponse = this.exec("registry $SerialNumber");
            Pattern pattern = Pattern.compile("= (?<serial>\\d{9})");
            Matcher matcher = pattern.matcher(serialNumberResponse);
            if (matcher.find()) {
                return Integer.parseInt(matcher.group("serial"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(JniorControlConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return -1;
    }

    public abstract boolean storeFile(String var1, File var2) throws IOException;

    public abstract void send(String var1) throws Exception;

    public abstract String exec(String var1) throws Exception;

    public abstract String exec(String var1, int var2) throws Exception;

    public abstract boolean retrieveFile(String var1, FileOutputStream var2) throws IOException;

    public abstract boolean login(String var1, String var2) throws LoginFailedException;

    public abstract FileListing[] listFiles(String var1) throws IOException;

    public abstract void allowReconnect(boolean var1);
}

