/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.backup;

import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.janoslib.utils.PathUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.backup.DownloadLogic;
import com.integ.supporter.backup.DownloadLogicFactory;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.json.JSONObject;

public class OverwriteDownloadLogic
extends DownloadLogic {
    public OverwriteDownloadLogic(JSONObject fileJson) {
        super(fileJson);
    }

    @Override
    public String getStorageDirectory() {
        String storagePath = PathUtils.combine(Constants.BACKUP_DIRECTORY, String.valueOf(this.getSerialNumber()), "files");
        return storagePath;
    }

    @Override
    public String getLocalPath() {
        String storagePath = this.getStorageDirectory();
        String newFilePath = PathUtils.combine(storagePath, this._filepath);
        return newFilePath;
    }

    @Override
    public boolean isFileNeeded() {
        String newFilePath = this.getLocalPath();
        if (new File(newFilePath).exists()) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] fileContentBytes = FileUtils.readAllBytes(newFilePath);
                md.update(fileContentBytes);
                byte[] digest = md.digest();
                String newMd5String = HexUtils.bytesToHex(digest).toUpperCase();
                if (newMd5String.equalsIgnoreCase(this._fileJson.getString("md5"))) {
                    return false;
                }
            }
            catch (NoSuchAlgorithmException ex) {
                DownloadLogicFactory.LOGGER.severe(ex.toString());
            }
            catch (IOException ex) {
                DownloadLogicFactory.LOGGER.severe(ex.toString());
            }
        } else {
            DownloadLogicFactory.LOGGER.info(String.format("md5 for %s has changed", this._filepath));
        }
        return true;
    }

    @Override
    public String whyNotNeeded() {
        return String.format("%s has not changed since the last time it was downloaded", this._filepath);
    }

    @Override
    public File saveFileAs(byte[] fileContentBytes) {
        try {
            String localPath = this.getLocalPath();
            this.saveFileAs(localPath, fileContentBytes);
            return new File(localPath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

