/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.config;

import com.integ.supporter.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PropertiesSettings {
    protected static final Properties DEFAULT_PROPS = new Properties();
    private final String _filename;
    protected Properties _props;
    private ArrayList<ChangeListener> _listenerList = new ArrayList();

    protected PropertiesSettings() {
        this._filename = String.format("%s%s.properties", Constants.CONFIG_DIRECTORY, this.getClass().getName());
    }

    public void addChnageListener(ChangeListener listener) {
        this._listenerList.add(listener);
    }

    protected void changed() {
        for (ChangeListener listener : this._listenerList) {
            listener.stateChanged(new ChangeEvent(this));
        }
        this.saveConfig();
    }

    protected void loadConfig() {
        this._props = new Properties(DEFAULT_PROPS);
        File propsFile = new File(this._filename);
        try (FileReader reader = new FileReader(propsFile);){
            this._props.load(reader);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.saveConfig(this._props);
    }

    protected void saveConfig() {
        this.saveConfig(this._props);
    }

    private void saveConfig(Properties props) {
        File propsFile = new File(this._filename);
        try (FileWriter writer = new FileWriter(propsFile);){
            props.store(writer, "vertical nav settings");
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

