/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net.beacon;

import com.integ.janoslib.net.beacon.JniorVersion;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.beacon.StatusChangedListener;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class JniorInfo {
    public static final int BEACON_ASSERT = 1;
    public static final int BEACON_ERRORS = 2;
    public static final int BEACON_MEMERR = 4;
    public static final int BEACON_REFORMAT = 8;
    public static final int BEACON_FLASH = 16;
    public static final int BEACON_DUMP = 32;
    public static final int BEACON_APPERR = 64;
    public static final int BEACON_RESERVED = 128;
    public static final int IS_SERIES_3 = 256;
    private static final transient Object GET_INFO_LOCK = new Object();
    public static final int ALIVE = 0;
    public static final int REBOOT_REQUESTED = 1;
    public static final int REBOOTING = 2;
    public static final int GETTING_NETWORK_CAPTURE = 256;
    private boolean _isActive;
    private int SerialNumber;
    public String Model;
    public String Hostname;
    public String IpAddress;
    public String SubnetMask;
    public String PhysicalAddress;
    public boolean AutoAnnounce;
    public String BuildTag;
    public JniorVersion OsVersion;
    public JniorVersion FullOsVersion;
    public int ProtocolPort;
    public Date BootTime;
    public Date LastAnnounced;
    public short AttentionInfo;
    public transient Date CurrentTime;
    public String Gateway;
    public String PrimaryDns;
    public String SecondaryDns;
    public int DnsTimeout = 5000;
    public String DhcpServer;
    public String DomainName;
    public String Timezone;
    public boolean DhcpEnabled;
    private transient String PublicHostAddress;
    public transient int BeaconPort = 4444;
    public transient String Username = "jnior";
    public transient String Password = "jnior";
    public transient String Nonce;
    public transient int Status = 0;
    public transient boolean AccessibleFromLocalMachine;
    private transient String _dumpModified;
    private transient String _errorsModified;
    public transient int TotalMemory;
    public transient int FreeMemory;
    public transient int MaxFreeMemory;
    public transient int LargestFreeBlock;
    public transient int FreeBlockCount;
    public transient long IdleTime;
    public transient long UpTime;
    public transient long MemoryTimestamp;
    private transient String _status;
    private InetAddress ReceivingAddress;
    protected ArrayList<StatusChangedListener> _statusChangedListenerList = new ArrayList();

    public String getStatus() {
        return this._status;
    }

    private JniorInfo() {
    }

    public JniorInfo(int serialNumber) {
        this.SerialNumber = serialNumber;
        this.setModel();
    }

    public JniorInfo setSerialNumber(int serialNumber) {
        if (0 != this.SerialNumber && serialNumber != serialNumber) {
            throw new RuntimeException("Serial Number has already been set and cannot be changed");
        }
        this.SerialNumber = serialNumber;
        this.setModel();
        return this;
    }

    public void clearActive() {
        this._isActive = false;
    }

    public void setActive() {
        this._isActive = true;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public boolean isError() {
        return 0 != this.AttentionInfo && !this.isWarning();
    }

    public boolean isWarning() {
        int i = this.AttentionInfo & 0x42;
        return 0 != (this.AttentionInfo & 0x42);
    }

    public boolean isSeries4() {
        return 600000000 <= this.getSerialNumber();
    }

    public boolean isSeries3() {
        boolean isSeries3;
        boolean bl = isSeries3 = 500000000 > this.getSerialNumber();
        if (isSeries3) {
            this.AttentionInfo = (short)(this.AttentionInfo | 0x100);
        }
        return isSeries3;
    }

    private void setModel() {
        int model = this.SerialNumber / 100000000;
        switch (model) {
            case 1: 
            case 2: {
                this.Model = "310";
                break;
            }
            case 3: {
                this.Model = "312";
                break;
            }
            case 4: {
                this.Model = "314";
                break;
            }
            case 6: {
                this.Model = "410";
                break;
            }
            case 7: {
                this.Model = "412";
                break;
            }
            case 8: {
                this.Model = "414";
                break;
            }
            case 9: {
                this.Model = "412DMX";
            }
        }
    }

    public int getSerialNumber() {
        return this.SerialNumber;
    }

    public String getPublicHostAddress() {
        return null != this.PublicHostAddress ? this.PublicHostAddress : this.IpAddress;
    }

    public JniorInfo setPublicHostAddress(String hostAddress) {
        this.PublicHostAddress = hostAddress;
        return this;
    }

    public JniorInfo clone() {
        JniorInfo jniorInfoClone = new JniorInfo();
        jniorInfoClone.SerialNumber = this.SerialNumber;
        jniorInfoClone.Model = this.Model;
        jniorInfoClone.Hostname = this.Hostname;
        jniorInfoClone.IpAddress = this.IpAddress;
        jniorInfoClone.SubnetMask = this.SubnetMask;
        jniorInfoClone.PhysicalAddress = this.PhysicalAddress;
        jniorInfoClone.AutoAnnounce = this.AutoAnnounce;
        jniorInfoClone.OsVersion = this.OsVersion;
        jniorInfoClone.FullOsVersion = this.FullOsVersion;
        jniorInfoClone.BuildTag = this.BuildTag;
        jniorInfoClone.ProtocolPort = this.ProtocolPort;
        jniorInfoClone.BootTime = this.BootTime;
        jniorInfoClone.LastAnnounced = this.LastAnnounced;
        jniorInfoClone.AttentionInfo = this.AttentionInfo;
        jniorInfoClone.Gateway = this.Gateway;
        jniorInfoClone.PrimaryDns = this.PrimaryDns;
        jniorInfoClone.SecondaryDns = this.SecondaryDns;
        jniorInfoClone.DnsTimeout = this.DnsTimeout;
        jniorInfoClone.DhcpServer = this.DhcpServer;
        jniorInfoClone.DomainName = this.DomainName;
        jniorInfoClone.Timezone = this.Timezone;
        jniorInfoClone.DhcpEnabled = this.DhcpEnabled;
        jniorInfoClone.Username = this.Username;
        jniorInfoClone.Password = this.Password;
        jniorInfoClone.Nonce = this.Nonce;
        jniorInfoClone.ReceivingAddress = this.ReceivingAddress;
        return jniorInfoClone;
    }

    public boolean equals(JniorInfo jniorInfo) {
        boolean equals = true;
        if (null == jniorInfo.Hostname || null == this.Hostname || !jniorInfo.Hostname.equals(this.Hostname)) {
            equals = false;
        }
        if (null == jniorInfo.FullOsVersion || null == this.FullOsVersion || !jniorInfo.FullOsVersion.equals(this.FullOsVersion)) {
            equals = false;
        }
        if (null == jniorInfo.IpAddress && null == this.IpAddress || !jniorInfo.IpAddress.equals(this.IpAddress)) {
            equals = false;
        }
        if (null != jniorInfo.Timezone && null != this.Timezone && !jniorInfo.Timezone.equals(this.Timezone)) {
            equals = false;
        }
        return equals;
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("SerialNumber", this.getSerialNumber());
        for (Field field : this.getClass().getFields()) {
            try {
                Object value;
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || (value = field.get(this)) == null) continue;
                jsonObject.put(field.getName(), value);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(JniorInfo.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(JniorInfo.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        }
        return jsonObject;
    }

    public static JniorInfo fromJSON(JSONObject jsonObject) {
        JniorInfo jniorInfo = new JniorInfo();
        for (Field field : jniorInfo.getClass().getFields()) {
            try {
                Object value;
                String fieldName = field.getName();
                if (!jsonObject.has(fieldName) || (value = jsonObject.get(fieldName)) == null) continue;
                if (field.getType().isAssignableFrom(Date.class) || field.getType().isAssignableFrom(JniorVersion.class)) {
                    // empty if block
                }
                field.set(jniorInfo, value);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                Logger.getLogger(JniorInfo.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                Logger.getLogger(JniorInfo.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.getLogger(JniorInfo.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        }
        return jniorInfo;
    }

    public String toString() {
        return this.SerialNumber + "-" + this.Hostname;
    }

    public int getSeries() {
        if (500000000 > this.SerialNumber) {
            return 3;
        }
        if (600000000 < this.SerialNumber) {
            return 4;
        }
        throw new RuntimeException("Invalid Serial Number: " + this.SerialNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInfo() {
        Object object = GET_INFO_LOCK;
        synchronized (object) {
            try {
                GET_INFO_LOCK.wait(5000L);
            }
            catch (InterruptedException ex) {
                Logger.getGlobal().log(Level.SEVERE, ExceptionUtils.getStackTrace(ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInfo() {
        Object object = GET_INFO_LOCK;
        synchronized (object) {
            GET_INFO_LOCK.notifyAll();
        }
    }

    public void setDumpModified(String modified) {
        this._dumpModified = modified;
    }

    public Object getDumpModified() {
        return this._dumpModified;
    }

    public void setErrorsModified(String modified) {
        this._errorsModified = modified;
    }

    public Object getErrorsModified() {
        return this._errorsModified;
    }

    public void setStatus(String status) {
        this._status = status;
        for (StatusChangedListener listener : this._statusChangedListenerList) {
            listener.statusChanged(this, status);
        }
    }

    public void addStatusChangedListener(StatusChangedListener listener) {
        this._statusChangedListenerList.add(listener);
    }

    public InetAddress getReceivingIpAddress() {
        return this.ReceivingAddress;
    }

    void setReceivingIPAddress(InetAddress receivingAddress) {
        this.ReceivingAddress = receivingAddress;
    }
}

