/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon.menus;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.JniorControlConnection;
import com.integ.supporter.JniorControlConnectionAuthenticationEvent;
import com.integ.supporter.JniorControlConnectionAuthenticationListener;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.beacon.menus.BeaconPopupMenu;
import com.integ.supporter.ui.dialogs.LoginDialog;
import com.integ.supporter.ui.toasts.MessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.awt.Frame;
import java.io.IOException;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

class SetTime
implements JniorControlConnectionAuthenticationListener {
    private final JniorInfo _jniorInfo;
    private JniorControlConnection _jniorControlConnection;
    private int authenticationFailedOccurances = 0;

    SetTime(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
    }

    @Override
    public void onAuthenticationSuccess(JniorControlConnectionAuthenticationEvent event) {
        System.out.println("");
    }

    @Override
    public void onAuthenticationFailed(JniorControlConnectionAuthenticationEvent event) {
        try {
            ++this.authenticationFailedOccurances;
            if (1 < this.authenticationFailedOccurances) {
                LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
                loginDialog.setDescription("Set Time for " + this._jniorInfo.IpAddress);
                loginDialog.centerParent();
                loginDialog.setVisible(true);
                if (loginDialog.getResult() == 1) {
                    this._jniorInfo.Username = loginDialog.getUsername();
                    this._jniorInfo.Password = loginDialog.getPassword();
                } else {
                    try {
                        this._jniorControlConnection.disconnect();
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this._jniorControlConnection.login(this._jniorInfo.Username, this._jniorInfo.Password);
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error providing custom credentials for " + this._jniorControlConnection.toString(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exec() {
        this._jniorControlConnection = JniorControlConnection.getFor(this._jniorInfo, BeaconTab.LOGGER);
        this._jniorControlConnection.addAuthenticationListener(this);
        this._jniorControlConnection.connect();
        Calendar calendar = Calendar.getInstance();
        String dateCommand = String.format("date %02d%02d%04d%02d%02d%02d", calendar.get(2) + 1, calendar.get(5), calendar.get(1), calendar.get(11), calendar.get(12), calendar.get(13));
        System.out.println(dateCommand);
        try {
            this._jniorControlConnection.exec(dateCommand);
            NotificationCollection.addNotification("Time has been manually set for " + this._jniorInfo.IpAddress);
            MessageToast messageToast = new MessageToast("Time has been manually set for " + this._jniorInfo.IpAddress);
            ToastNotifications.getInstance().display(messageToast);
        }
        catch (Exception ex) {
            Logger.getLogger(BeaconPopupMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                this._jniorControlConnection.disconnect();
            }
            catch (IOException ex) {
                Logger.getLogger(BeaconPopupMenu.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

