/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.snapshot.DefaultMutableTreeNode2;
import com.integ.supporter.ui.ActionableTabComponent;
import com.integ.supporter.ui.CheckBoxNodeData;
import com.integ.supporter.ui.CheckBoxNodeEditor;
import com.integ.supporter.ui.CheckBoxNodeRenderer;
import com.integ.supporter.ui.PercentageTabbedPaneUI;
import com.integ.supporter.ui.TreeNodesChangedListener;
import com.integ.supporter.ui.dialogs.JniorSelectionDialog;
import com.integ.supporter.updater.JniorUpdateInProgressCollection;
import com.integ.supporter.updater.JniorUpdateTab;
import com.integ.supporter.updater.OpenedUpdateProjects;
import com.integ.supporter.updater.UpdateProgressCollection;
import com.integ.supporter.updater.UpdateProjectEditorDialog;
import com.integ.supporter.updater.UpdateProjectExecutor;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.UpdateProjectListener;
import com.integ.supporter.updater.UpdateProjectPopupMenu;
import com.integ.supporter.updater.steps.ProjectStep;
import com.integ.supporter.updater.steps.ProjectStepFactory;
import com.integ.supporter.updater.steps.UnknownStepException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class UpdateProjectTab
extends JPanel
implements UpdateProjectListener {
    public static final String UPDATE_PROJECTS_DIRECTORY = Constants.SUPPORTER_DIRECTORY + "Update Projects/";
    public static final Logger LOGGER = RollingLog.getLogger("UpdateTab");
    private UpdateProjectFile _updateProjectFile;
    private final JMenuItem _abortMenuItem = new JMenuItem("Abort");
    private final JMenuItem _removeTabMenuItem = new JMenuItem("Remove Tab");
    private final JMenuItem _removeAllCompletedTabsMenuItem = new JMenuItem("Remove All Completed Tabs");
    private final JniorUpdateInProgressCollection _jniorUpdateInProgressCollection = new JniorUpdateInProgressCollection();
    private JButton abortToolbarButton;
    private JButton clearCompletedButton;
    private JButton closeToolbarButton;
    private JButton editToolbarButton;
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JToolBar jToolBar1;
    private JTree jTree1;
    private JButton publishToolbarButton;
    private JTabbedPane updatesTabPane;

    public UpdateProjectTab(UpdateProjectFile updateProjectFile) {
        this.initComponents();
        this.addTabChangeListener();
        JPopupMenu tabbedPanePopupMenu = this.createTabbedPanePopupMenu();
        this.updatesTabPane.setComponentPopupMenu(tabbedPanePopupMenu);
        this.updatesTabPane.setUI(new PercentageTabbedPaneUI());
        this._updateProjectFile = updateProjectFile;
        LOGGER.info("Loading " + this._updateProjectFile.getFilePath());
        DefaultMutableTreeNode root = this.loadSteps();
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.jTree1.setModel(treeModel);
        this.addTreeNodeCheckBoxListener();
        CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
        this.jTree1.setCellRenderer(renderer);
        CheckBoxNodeEditor editor = new CheckBoxNodeEditor(this.jTree1);
        this.jTree1.setCellEditor(editor);
        this.jTree1.setEditable(true);
        this.addPopupMenu();
        this.updatesTabPane.addChangeListener(e -> this.updateMenuStatus());
        this.addProgressCollectionListener();
    }

    private void addProgressCollectionListener() {
        UpdateProgressCollection.getInstance().addChangeListener(e -> {
            this.updateMenuStatus();
            try {
                JniorInfo jniorInfo;
                UpdateProjectExecutor updateProjectExecutor = (UpdateProjectExecutor)e.getSource();
                if (!updateProjectExecutor.getResult().isInProgress() && this._jniorUpdateInProgressCollection.isJniorInProgress(jniorInfo = updateProjectExecutor.getJniorInfo())) {
                    this._jniorUpdateInProgressCollection.removeUpdate(jniorInfo);
                }
            }
            catch (Exception ex) {
                NotificationCollection.addError("Error removing completed jnior update from the inprogress collection", ex);
            }
        });
    }

    public UpdateProjectFile getUpdateProjectFile() {
        return this._updateProjectFile;
    }

    private void addTabChangeListener() {
        this.updatesTabPane.addChangeListener(e -> {
            JniorUpdateTab jniorUpdateTab = (JniorUpdateTab)this.updatesTabPane.getSelectedComponent();
            if (null != jniorUpdateTab) {
                this.abortToolbarButton.setEnabled(jniorUpdateTab.isRunning());
            }
        });
    }

    private static DefaultMutableTreeNode add(DefaultMutableTreeNode parent, ProjectStep projectStep, boolean checked) {
        CheckBoxNodeData data = new CheckBoxNodeData(projectStep, checked);
        DefaultMutableTreeNode2 node = new DefaultMutableTreeNode2(data);
        parent.add(node);
        return node;
    }

    @Override
    public void loginFailed() {
        JOptionPane.showConfirmDialog(this, "Login Failed", "Login Failed", 0);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateProjectStepResult(ProjectStep projectStep, boolean result, int index, int total) {
    }

    @Override
    public void updateProjectResult(UpdateProjectExecutor updateProjectExecutor, boolean result) {
    }

    private JPopupMenu createTabbedPanePopupMenu() {
        System.out.println(String.format("%s create popup menu", this.getClass().getName()));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setMinimumSize(new Dimension(200, 1));
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                System.out.println(String.format("%s popup will become visible", this.getClass().getName()));
                Component selectedTabComponent = UpdateProjectTab.this.updatesTabPane.getSelectedComponent();
                JniorUpdateTab selectedJniorUpdateTab = null != selectedTabComponent ? (JniorUpdateTab)selectedTabComponent : null;
                boolean abortAllowed = null != selectedJniorUpdateTab && selectedJniorUpdateTab.isRunning();
                UpdateProjectTab.this._abortMenuItem.setEnabled(abortAllowed);
                boolean removeTabAllowed = null != selectedJniorUpdateTab && !selectedJniorUpdateTab.isRunning();
                UpdateProjectTab.this._removeTabMenuItem.setEnabled(removeTabAllowed);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this._abortMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateProjectTab.this.abortAllUpdates();
            }
        });
        popupMenu.add(this._abortMenuItem);
        this._removeTabMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component selectedTabComponent = UpdateProjectTab.this.updatesTabPane.getSelectedComponent();
                UpdateProjectTab.this.updatesTabPane.remove(selectedTabComponent);
            }
        });
        popupMenu.add(this._removeTabMenuItem);
        this._removeAllCompletedTabsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateProjectTab.this.removeCompletedUpdates();
            }
        });
        popupMenu.add(this._removeAllCompletedTabsMenuItem);
        return popupMenu;
    }

    private void removeCompletedUpdates() {
        for (int i = 0; i < this.updatesTabPane.getTabCount(); ++i) {
            JniorUpdateTab jniorUpdateTab;
            Component updateTabComponent = this.updatesTabPane.getComponentAt(i);
            if (!(updateTabComponent instanceof JniorUpdateTab) || (jniorUpdateTab = (JniorUpdateTab)updateTabComponent).isRunning()) continue;
            this.updatesTabPane.remove(jniorUpdateTab);
            --i;
        }
    }

    private void abortAllUpdates() {
        int result = JOptionPane.showConfirmDialog(SupporterMain.getMainFrame(), "Are you sure you want to abort the update?");
        if (1 == result) {
            return;
        }
        for (int i = 0; i < this.updatesTabPane.getTabCount(); ++i) {
            JniorUpdateTab jniorUpdateTab = (JniorUpdateTab)this.updatesTabPane.getComponentAt(i);
            if (null == jniorUpdateTab) continue;
            jniorUpdateTab.abort();
        }
    }

    private void updateMenuStatus() {
        this.closeToolbarButton.setEnabled(!this.isUpdateInProgress());
        boolean isRunning = false;
        boolean hasCompleted = false;
        for (int i = 0; i < this.updatesTabPane.getTabCount(); ++i) {
            JniorUpdateTab jniorUpdateTab = (JniorUpdateTab)this.updatesTabPane.getComponentAt(i);
            if (null == jniorUpdateTab) continue;
            isRunning |= jniorUpdateTab.isRunning();
            hasCompleted |= jniorUpdateTab.isComplete();
        }
        System.out.println("updateMenuStatus()");
        this.publishToolbarButton.setEnabled(!isRunning);
        this.abortToolbarButton.setEnabled(isRunning);
        this.clearCompletedButton.setEnabled(hasCompleted);
    }

    public boolean isUpdateInProgress() {
        JniorUpdateTab jniorUpdateTab;
        boolean running = false;
        for (int i = 0; running && i < this.updatesTabPane.getComponentCount(); running |= jniorUpdateTab.isRunning(), ++i) {
            jniorUpdateTab = (JniorUpdateTab)this.updatesTabPane.getComponent(i);
        }
        return running;
    }

    public void closeTab() {
        int result = JOptionPane.showConfirmDialog(SupporterMain.getMainFrame(), "Are you sure you want to close the " + this._updateProjectFile.getTitle() + " update?", "Are you sure?", 0);
        if (0 != result) {
            return;
        }
        LOGGER.info(String.format("Close %s", this._updateProjectFile.getFilePath()));
        OpenedUpdateProjects.getInstance().remove(this._updateProjectFile);
    }

    public void publish(JniorInfo targetJniorInfo) throws IOException {
        LOGGER.info(String.format("publishing %s update to %s", this._updateProjectFile.getTitle(), targetJniorInfo.IpAddress));
        ArrayList<ProjectStep> selectedSteps = new ArrayList<ProjectStep>();
        DefaultTreeModel model = (DefaultTreeModel)this.jTree1.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            CheckBoxNodeData checkBoxNodeData;
            boolean isChecked;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)root.getChildAt(i);
            Object childNodeUserObject = childNode.getUserObject();
            if (!(childNodeUserObject instanceof CheckBoxNodeData) || !(isChecked = (checkBoxNodeData = (CheckBoxNodeData)childNodeUserObject).isChecked())) continue;
            try {
                ProjectStep projectStep = (ProjectStep)checkBoxNodeData.getObject();
                ProjectStep clonedProjectStep = ProjectStepFactory.getProjectStep(projectStep.getXmlElement());
                clonedProjectStep.setCheckedOnLoad(isChecked);
                clonedProjectStep.setUpdateProject(this._updateProjectFile);
                selectedSteps.add(clonedProjectStep);
                continue;
            }
            catch (UnknownStepException ex) {
                LOGGER.severe(ExceptionUtils.getStackTrace(ex));
            }
        }
        JniorUpdateTab jniorUpdateTab = new JniorUpdateTab(this._updateProjectFile, targetJniorInfo, selectedSteps);
        jniorUpdateTab.setListener(this);
        String title = targetJniorInfo.IpAddress;
        this.updatesTabPane.insertTab(title, null, jniorUpdateTab, "Updating " + targetJniorInfo.IpAddress, 0);
        this.updatesTabPane.setSelectedComponent(jniorUpdateTab);
        ActionableTabComponent closeTabComponent = new ActionableTabComponent(this.updatesTabPane);
        closeTabComponent.addActionListener(e1 -> {
            JniorUpdateTab jniorUpdateTab1;
            Object o = e1.getSource();
            int index = this.updatesTabPane.indexOfTabComponent((Component)o);
            boolean isRunning = false;
            Component updateTabComponent = this.updatesTabPane.getComponentAt(index);
            if (updateTabComponent instanceof JniorUpdateTab && (isRunning = (jniorUpdateTab1 = (JniorUpdateTab)updateTabComponent).isRunning())) {
                JniorInfo jniorInfo = jniorUpdateTab1.getJniorInfo();
                int result = JOptionPane.showConfirmDialog(SupporterMain.getMainFrame(), "Are you sure you want to abort the update for " + jniorInfo.toString());
                if (1 == result) {
                    return;
                }
                jniorUpdateTab.abort();
            }
            this.updatesTabPane.remove(index);
        });
        int index = this.updatesTabPane.indexOfTab(title);
        this.updatesTabPane.setTabComponentAt(index, closeTabComponent);
        UpdateProjectExecutor updateProjectExecutor = jniorUpdateTab.publish();
        this._jniorUpdateInProgressCollection.startUpdate(targetJniorInfo, updateProjectExecutor);
        this.updateMenuStatus();
    }

    public int getUpdatesInProgressCount() {
        return this._jniorUpdateInProgressCollection.getInProgressCount();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.closeToolbarButton = new JButton();
        this.editToolbarButton = new JButton();
        this.publishToolbarButton = new JButton();
        this.abortToolbarButton = new JButton();
        this.clearCompletedButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.jTree1 = new JTree();
        this.updatesTabPane = new JTabbedPane();
        this.jButton1.setText("jButton1");
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setRollover(true);
        this.closeToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/cancel.png")));
        this.closeToolbarButton.setText("Close");
        this.closeToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.closeToolbarButton.setFocusable(false);
        this.closeToolbarButton.setVerticalTextPosition(3);
        this.closeToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectTab.this.closeToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.closeToolbarButton);
        this.editToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/cog.png")));
        this.editToolbarButton.setText("Edit");
        this.editToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.editToolbarButton.setFocusable(false);
        this.editToolbarButton.setVerticalTextPosition(3);
        this.editToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectTab.this.editToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.editToolbarButton);
        this.publishToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/control_play_blue.png")));
        this.publishToolbarButton.setText("Publish");
        this.publishToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.publishToolbarButton.setFocusable(false);
        this.publishToolbarButton.setVerticalTextPosition(3);
        this.publishToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectTab.this.publishToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.publishToolbarButton);
        this.abortToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/stop.png")));
        this.abortToolbarButton.setText("Abort All");
        this.abortToolbarButton.setToolTipText("Close");
        this.abortToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.abortToolbarButton.setEnabled(false);
        this.abortToolbarButton.setFocusable(false);
        this.abortToolbarButton.setVerticalTextPosition(3);
        this.abortToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectTab.this.abortToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.abortToolbarButton);
        this.clearCompletedButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/table_delete.png")));
        this.clearCompletedButton.setText("Clear Completed");
        this.clearCompletedButton.setEnabled(false);
        this.clearCompletedButton.setFocusable(false);
        this.clearCompletedButton.setVerticalTextPosition(3);
        this.clearCompletedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectTab.this.clearCompletedButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.clearCompletedButton);
        this.jPanel1.add((Component)this.jToolBar1, "Center");
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setMinimumSize(new Dimension(300, 25));
        this.jSplitPane1.setPreferredSize(new Dimension(300, 25));
        this.jScrollPane2.setViewportView(this.jTree1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane2);
        this.updatesTabPane.setTabPlacement(4);
        this.updatesTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                UpdateProjectTab.this.updatesTabPaneStateChanged(evt);
            }
        });
        this.jSplitPane1.setRightComponent(this.updatesTabPane);
        this.jPanel2.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.jPanel2, "Center");
    }

    private void closeToolbarButtonActionPerformed(ActionEvent evt) {
        this.closeTab();
    }

    private void abortToolbarButtonActionPerformed(ActionEvent evt) {
        this.abortAllUpdates();
    }

    private void publishToolbarButtonActionPerformed(ActionEvent evt) {
        new Thread(() -> {
            JniorSelectionDialog dlg = new JniorSelectionDialog((Frame)SupporterMain.getMainFrame(), true);
            dlg.setMinimumSize(new Dimension(800, 600));
            dlg.setVisible(true);
            JniorInfo[] selectedJniors = dlg.getSelectedJniors();
            LOGGER.info(String.format("%d jniors selected", selectedJniors.length));
            for (JniorInfo selectedRemoteJniorInfo : selectedJniors) {
                try {
                    if (this._jniorUpdateInProgressCollection.isJniorInProgress(selectedRemoteJniorInfo)) continue;
                    this.publish(selectedRemoteJniorInfo);
                }
                catch (IOException ex) {
                    Logger.getLogger(UpdateProjectTab.class.getName()).severe(ex.getMessage());
                }
            }
        }).start();
    }

    private void editToolbarButtonActionPerformed(ActionEvent evt) {
        this.showEditProjectDialog();
    }

    private void updatesTabPaneStateChanged(ChangeEvent evt) {
        int selectedTabIndex = this.updatesTabPane.getSelectedIndex();
        System.out.println("Tab: " + selectedTabIndex);
    }

    private void clearCompletedButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.updatesTabPane.getTabCount(); ++i) {
            JniorUpdateTab jniorUpdateTab = (JniorUpdateTab)this.updatesTabPane.getComponentAt(i);
            UpdateProjectExecutor updateProjectExecutor = jniorUpdateTab.getUpdateProjectExecutor();
            if (!updateProjectExecutor.getResult().hasCompleted() && !updateProjectExecutor.getResult().wasAborted()) continue;
            this._jniorUpdateInProgressCollection.removeUpdate(jniorUpdateTab.getJniorInfo());
            this.updatesTabPane.remove(jniorUpdateTab);
            UpdateProgressCollection.getInstance().remove(updateProjectExecutor);
            --i;
        }
        this.clearCompletedButton.setEnabled(false);
    }

    public void showEditProjectDialog() {
        try {
            UpdateProjectEditorDialog updateProjectEditorDialog = new UpdateProjectEditorDialog((Frame)SupporterMain.getMainFrame(), true);
            updateProjectEditorDialog.setUpdateProject(this._updateProjectFile);
            int result = updateProjectEditorDialog.showEditorDialog();
            if (result == 0) {
                this._updateProjectFile = new UpdateProjectFile(updateProjectEditorDialog.getFile());
                this._updateProjectFile.load();
                DefaultMutableTreeNode root = this.loadSteps();
                DefaultTreeModel treeModel = new DefaultTreeModel(root);
                this.jTree1.setModel(treeModel);
                JTabbedPane tabbedPane = (JTabbedPane)this.getParent();
                int index = tabbedPane.getSelectedIndex();
                tabbedPane.setTitleAt(index, this._updateProjectFile.getTitle());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(UpdateProjectTab.class.getName()).severe(ex.getMessage());
        }
    }

    private void addPopupMenu() {
        UpdateProjectPopupMenu popupMenu = new UpdateProjectPopupMenu(this);
    }

    private DefaultMutableTreeNode loadSteps() {
        CheckBoxNodeData data = new CheckBoxNodeData("Project Steps", true);
        DefaultMutableTreeNode2 root = new DefaultMutableTreeNode2(data);
        ArrayList<ProjectStep> projectStepArrayList = this._updateProjectFile.getSteps();
        for (ProjectStep projectStep : projectStepArrayList) {
            LOGGER.info("Add " + projectStep.toString());
            UpdateProjectTab.add(root, projectStep, projectStep.isCheckedOnLoad());
        }
        return root;
    }

    private void addTreeNodeCheckBoxListener() {
        final DefaultTreeModel treeModel = (DefaultTreeModel)this.jTree1.getModel();
        treeModel.addTreeModelListener(new TreeNodesChangedListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                if (null == e.getChildren()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeModel.getRoot();
                    CheckBoxNodeData nodeUserObject = (CheckBoxNodeData)node.getUserObject();
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                        Object childNodeUserObject = childNode.getUserObject();
                        if (!(childNodeUserObject instanceof CheckBoxNodeData)) continue;
                        CheckBoxNodeData projectStepNodeData = (CheckBoxNodeData)childNodeUserObject;
                        projectStepNodeData.setChecked(nodeUserObject.isChecked());
                    }
                }
            }
        });
    }
}

