/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.dialogs;

import com.integ.supporter.AssemblyInfo;
import com.integ.supporter.RollingLog;
import com.integ.supporter.WebUrlLauncher;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class AboutDialog
extends JDialog {
    private static final String FLATLAF_URL = "https://www.formdev.com/flatlaf/";
    private static final String FONT_AWESOME_URL = "https://www.fontawesome.com";
    private static final Logger LOGGER = RollingLog.getLogger("all_properties");
    private JLabel flatLafLink;
    private JLabel fontAwesomeLink;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel lblApplicationInfo;
    private JLabel lblVirtualMachineInfo;

    public AboutDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        String applicationInfoStringString = String.format("%s %s (built: %s)", AssemblyInfo.getName(), AssemblyInfo.getVersion(), AssemblyInfo.getBuildTime());
        this.lblApplicationInfo.setText(applicationInfoStringString);
        String vmInfoString = String.format("%s %s %s", System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.version"));
        this.lblVirtualMachineInfo.setText(vmInfoString);
        this.flatLafLink.setText("<html><a href=\"\">https://www.formdev.com/flatlaf/</a></html>");
        this.fontAwesomeLink.setText("<html><a href=\"\">https://www.fontawesome.com</a></html>");
        Object fullEnv = "";
        Properties properties = System.getProperties();
        for (Object keyName : properties.keySet()) {
            fullEnv = (String)fullEnv + String.format("%s=%s%n", keyName, properties.get(keyName));
        }
        LOGGER.info((String)fullEnv);
    }

    private void initComponents() {
        this.lblApplicationInfo = new JLabel();
        this.lblVirtualMachineInfo = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.flatLafLink = new JLabel();
        this.fontAwesomeLink = new JLabel();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("About...");
        this.setResizable(false);
        this.lblApplicationInfo.setText("JNIOR Supporter");
        this.lblVirtualMachineInfo.setText("Virtual Machine Info");
        this.jLabel3.setText("Swing Look And Feel provided by the FlatLAF project");
        this.jLabel4.setText("Icons provided by FontAwesome");
        this.flatLafLink.setText("FLATLAF_URL");
        this.flatLafLink.setCursor(new Cursor(12));
        this.flatLafLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AboutDialog.this.flatLafLinkMouseClicked(evt);
            }
        });
        this.fontAwesomeLink.setText("FONT_AWESOME_URL");
        this.fontAwesomeLink.setCursor(new Cursor(12));
        this.fontAwesomeLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AboutDialog.this.fontAwesomeLinkMouseClicked(evt);
            }
        });
        this.jLabel1.setFont(new Font("Segoe UI", 1, 12));
        this.jLabel1.setText("Credits:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(31, 31, 31).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.fontAwesomeLink)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.flatLafLink)).addComponent(this.lblVirtualMachineInfo).addComponent(this.lblApplicationInfo)).addContainerGap(135, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.lblApplicationInfo).addGap(18, 18, 18).addComponent(this.lblVirtualMachineInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.flatLafLink)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.fontAwesomeLink)).addGap(27, 27, 27)));
        this.pack();
    }

    private void flatLafLinkMouseClicked(MouseEvent evt) {
        WebUrlLauncher.go(FLATLAF_URL);
    }

    private void fontAwesomeLinkMouseClicked(MouseEvent evt) {
        WebUrlLauncher.go(FONT_AWESOME_URL);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AboutDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(AboutDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AboutDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(AboutDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> {
            AboutDialog dialog = new AboutDialog((Frame)new JFrame(), true);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            dialog.setVisible(true);
        });
    }
}

