/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.util.SystemInfo;
import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.net.beacon.commands.QueryAllCommand;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import com.integ.supporter.ApplicationUpdater;
import com.integ.supporter.AssemblyInfo;
import com.integ.supporter.Constants;
import com.integ.supporter.JniorPhomeReporter;
import com.integ.supporter.NTPClient;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterUtilities;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.snapshot.SnapshotInProgressCollection;
import com.integ.supporter.snapshot.SnapshotProgressCollection;
import com.integ.supporter.snapshot.TakeSnapshot;
import com.integ.supporter.ui.layout.MainFrame;
import com.integ.supporter.ui.menus.MainMenu;
import com.integ.supporter.updater.UpdateProgressCollection;
import com.integ.supporter.updater.UpdateProjectExecutor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.json.JSONObject;

public class SupporterMain
extends JPanel {
    private static final SimpleDateFormat FOLDER_DATE_FORMAT;
    private static SupporterMain INSTANCE;
    private static MainFrame MainFrame;
    public static Logger LOGGER;
    public static String PUBLIC_IP_ADDRESS;

    public static SupporterMain getInstance() {
        return INSTANCE;
    }

    private static void removeAllLckFiles() {
        SupporterMain.removeLckFiles(Constants.LOGS_DIRECTORY);
        SupporterMain.removeLckFiles(Constants.SNAPSHOT_LOGS_DIRECTORY);
        SupporterMain.removeLckFiles(Constants.UPDATES_LOGS_DIRECTORY);
    }

    public static File getTempDirectory() {
        File tempDirectory = new File(Constants.TEMP_DIRECTORY);
        if (!tempDirectory.exists()) {
            tempDirectory.mkdir();
        }
        return tempDirectory;
    }

    private static void removeLckFiles(String directory) {
        System.out.println("remove lock files for " + directory);
        String[] files = new File(directory).list((File dir, String name1) -> {
            try {
                File file;
                String fullFilename = String.format("%s%s", directory, name1);
                boolean accept = name1.endsWith(".lck");
                if (!accept && (file = new File(fullFilename)).exists() && 0L == file.length()) {
                    accept = true;
                }
                return accept;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        });
        if (null != files) {
            for (int i = files.length - 1; i >= 0; --i) {
                String filenameString = files[i];
                String fullFilename = String.format("%s%s", directory, filenameString);
                File file = new File(fullFilename);
                if (!file.isFile() || !file.delete()) continue;
                System.out.println(" removed " + fullFilename);
            }
        }
    }

    public static void main(String[] args) {
        if (0 < args.length) {
            if ("-backup".equalsIgnoreCase(args[0]) && 2 <= args.length) {
                String host = args[1];
                Logger logger = RollingLog.getLogger(String.format("Snapshot_%s", host));
                try {
                    JniorInfo jniorInfo = new JniorInfo(0);
                    jniorInfo.IpAddress = host;
                    if (4 <= args.length) {
                        jniorInfo.Username = args[2];
                        jniorInfo.Password = args[3];
                    }
                    TakeSnapshot snapshot = new TakeSnapshot(jniorInfo);
                    String folder = String.format("%s%s_%s", Constants.TEMP_DIRECTORY, jniorInfo.IpAddress, FOLDER_DATE_FORMAT.format(new Date()));
                    snapshot.setFolder(folder);
                    snapshot.setLogger(logger);
                    snapshot.run();
                }
                catch (Exception jniorInfo) {
                    // empty catch block
                }
                Set<Thread> threads = Thread.getAllStackTraces().keySet();
                for (Thread t : threads) {
                    String name = t.getName();
                    Thread.State state = t.getState();
                    int priority = t.getPriority();
                    String type = t.isDaemon() ? "Daemon" : "Normal";
                    System.out.printf("%-20s \t %s \t %d \t %s %s\n", new Object[]{name, state, priority, type, t.getClass()});
                }
            }
        } else {
            try {
                System.out.println("set look and feel");
                SupporterMain.setLookAndFeel();
            }
            catch (Exception ex) {
                System.err.println("Failed to initialize Look and Feel");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SupporterMain.createAndShowGUI();
                }
            });
        }
    }

    private static void createAndShowGUI() {
        System.out.println("create and show GUI");
        MainFrame = new MainFrame(AssemblyInfo.getName() + " v" + AssemblyInfo.getVersion());
        MainFrame.setDefaultCloseOperation(0);
        MainFrame.setMinimumSize(new Dimension(900, 600));
        MainFrame.setExtendedState(6);
        MainFrame.setJMenuBar(new MainMenu());
        final SupporterMain supporterMain = new SupporterMain();
        MainFrame.initUI();
        MainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                supporterMain.tryExit();
            }
        });
        try {
            URL iconURL = supporterMain.getClass().getResource("/resources/integ.png");
            ImageIcon icon = new ImageIcon(iconURL);
            MainFrame.setIconImage(icon.getImage());
        }
        catch (Exception ex) {
            LOGGER.severe(ExceptionUtils.getStackTrace(ex));
        }
        ApplicationUpdater.CheckForUpdates();
        MainFrame.setVisible(true);
    }

    private static void setLookAndFeel() throws UnsupportedLookAndFeelException {
        System.out.println("assign FlatLAF");
        FlatLightLaf lookAndFeel = new FlatLightLaf();
        UIManager.setLookAndFeel(lookAndFeel);
        System.out.println("use native window decorations");
        FlatLightLaf.setUseNativeWindowDecorations(true);
        System.out.println("use unified title and menu bar");
        UIManager.put("TitlePane.menuBarEmbedded", true);
        UIManager.put("TitlePane.unifiedBackground", true);
        FlatLightLaf.revalidateAndRepaintAllFramesAndDialogs();
        FlatLightLaf.repaintAllFramesAndDialogs();
        System.out.println("change font");
        Font newFont = new Font("Segoe UI", 0, 12);
        UIManager.put("defaultFont", newFont);
        FlatLaf.updateUI();
        if (SystemInfo.isLinux) {
            System.out.println("linux set default look and feel");
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
    }

    public SupporterMain() {
        INSTANCE = this;
        SupporterUtilities.initTrayIcon();
        this.startBeacon();
        new Thread(() -> {
            NTPClient.getNetworkTime(true);
            MainFrame.getStatusBar().setNTPStatus(String.format("%.3f sec", (double)NTPClient.getOffset() / 1000.0));
            this.getPublicIpAddress();
            MainFrame.getStatusBar().setPublicIpAddress(PUBLIC_IP_ADDRESS);
        }).start();
        UpdateProgressCollection.getInstance().addChangeListener(e -> {
            int activeCount;
            UpdateProjectExecutor updateProjectExecutor = (UpdateProjectExecutor)e.getSource();
            if (updateProjectExecutor.getResult().wasSuccessful() && 0 == (activeCount = UpdateProgressCollection.getInstance().getActiveCount())) {
                SupporterUtilities.playSound("pristine.wav");
            }
        });
        SnapshotProgressCollection.getInstance().addChangeListener(e -> {
            int activeCount;
            TakeSnapshot takeSnapshot = (TakeSnapshot)e.getSource();
            if (takeSnapshot.getResult().wasSuccessful() && 0 == (activeCount = SnapshotProgressCollection.getInstance().getActiveCount())) {
                SupporterUtilities.playSound("pristine.wav");
            }
        });
        JniorPhomeReporter.init();
    }

    private void startBeacon() {
        Beacon.getInstance().addBeaconServerListener(() -> {
            BeaconTab.LOGGER.info("beacon server ready");
            try {
                Beacon.getInstance().broadcastCommand(new QueryAllCommand());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        });
        Beacon.getInstance().start();
    }

    private void getPublicIpAddress() {
        String whatsMyIpUrlString = "https://api.ipify.org?format=json";
        try (Scanner s = new Scanner(new URL(whatsMyIpUrlString).openStream(), "UTF-8");){
            JSONObject myIpAddressJson = new JSONObject(s.next());
            PUBLIC_IP_ADDRESS = myIpAddressJson.getString("ip");
            Logger.getGlobal().log(Level.INFO, "Public IP address is {0}", PUBLIC_IP_ADDRESS);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void tryExit() {
        try {
            String updatesInProgressString;
            int canExit = 0;
            int snapshotsInProgressCount = SnapshotInProgressCollection.getInProgressCount();
            String snapshotsInProgressString = 1 == snapshotsInProgressCount ? "is 1 Snapshot" : String.format("are %d Snapshots", snapshotsInProgressCount);
            int updatesInProgressCount = UpdateProgressCollection.getInstance().getActiveCount();
            String string = updatesInProgressString = 1 == updatesInProgressCount ? "1 Update" : String.format("%d Updates", updatesInProgressCount);
            if (0 < snapshotsInProgressCount && 0 < updatesInProgressCount) {
                canExit = JOptionPane.showConfirmDialog(this, String.format("There %s and %s in progress.  Do you want to abort them and exit?", snapshotsInProgressString, updatesInProgressString), "Snapshots and Updates in progress", 0, 1);
            } else if (0 < snapshotsInProgressCount) {
                canExit = JOptionPane.showConfirmDialog(this, String.format("There %s in progress.  Do you want to abort them and exit?", snapshotsInProgressString), "Snapshots in progress", 0, 1);
            } else if (0 < updatesInProgressCount) {
                canExit = JOptionPane.showConfirmDialog(this, String.format("There %s in progress.  Do you want to abort them and exit?", updatesInProgressString), "Updates in progress", 0, 1);
            }
            if (0 == canExit) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            String stackTrace = ExceptionUtils.getStackTrace(ex);
            LOGGER.severe(stackTrace);
            JOptionPane.showMessageDialog(this, "Error trying to exit", stackTrace, 0);
            System.exit(-1);
        }
    }

    public static MainFrame getMainFrame() {
        return MainFrame;
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT %4$-7s %5$s %n");
        FOLDER_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
        LOGGER = null;
        PUBLIC_IP_ADDRESS = "unknown";
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                String message = String.format("Uncaught: %s: %s", e.toString(), e.getStackTrace()[0]);
                NotificationCollection.addError(message, e);
            }
        });
        try {
            System.out.println(String.format("SUPPORTER_DIRECTORY: %s", Constants.SUPPORTER_DIRECTORY));
            new File(Constants.INTEG_DIRECTORY).mkdir();
            new File(Constants.SUPPORTER_DIRECTORY).mkdir();
            new File(Constants.LOGS_DIRECTORY).mkdir();
            new File(Constants.SNAPSHOT_LOGS_DIRECTORY).mkdir();
            new File(Constants.UPDATES_LOGS_DIRECTORY).mkdir();
            SupporterMain.removeAllLckFiles();
            LOGGER = RollingLog.getLogger("JniorSupporter");
            LOGGER.info(String.format("%s v%s", AssemblyInfo.getName(), AssemblyInfo.getVersion()));
            RollingLog.setGlobalLogger(LOGGER);
            LOGGER.info(String.format("%s %s (%s)", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.home")));
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> LOGGER.info(key + ": " + value)));
            System.out.println("add shutodwn hook");
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    SupporterMain.removeAllLckFiles();
                }
            }));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("ensure directories");
        File tempDirectory = new File(Constants.TEMP_DIRECTORY);
        try {
            if (tempDirectory.exists()) {
                FileUtils.deleteDirectory(tempDirectory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        tempDirectory.mkdir();
        new File(Constants.CONFIG_DIRECTORY).mkdir();
        new File(Constants.LISTINGS_DIRECTORY).mkdir();
        new File(Constants.JRGET_PACKAGES_FOLDER).mkdir();
        new File(Constants.SNAPSHOTS_FOLDER).mkdir();
        new File(Constants.UPDATE_PROJECTS_DIRECTORY).mkdir();
        new File(Constants.CINEMA_FILES_FOLDER).mkdir();
    }
}

