/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.jtreetable;

import com.integ.supporter.ui.jtreetable.JTreeTable;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private final JTreeTable _treeTable;
    protected int _visibleRow;

    public TreeTableCellRenderer(JTreeTable treeTable, TreeModel model) {
        super(model);
        this._treeTable = treeTable;
        super.setRowHeight(this.getRowHeight() + 2);
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (rowHeight > 0) {
            super.setRowHeight(rowHeight);
            if (this._treeTable != null && this._treeTable.getRowHeight() != rowHeight) {
                this._treeTable.setRowHeight(this.getRowHeight());
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this._treeTable.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        g.translate(0, -this._visibleRow * this.getRowHeight());
        super.paint(g);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)c;
        dtcr.setBorder(BorderFactory.createEmptyBorder());
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        this._visibleRow = row;
        return this;
    }
}

