/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.documentfilters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class IpAddressDocumentFilter
extends DocumentFilter {
    private final String OCTET_STRING = "(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])";
    private final Pattern ipAddressPattern = Pattern.compile(String.format("^(%s((\\.(%s)?)?){0,3})?$", "(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])", "(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])"));

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        Document doc = fb.getDocument();
        StringBuilder sb = new StringBuilder();
        sb.append(doc.getText(0, doc.getLength()));
        sb.insert(offset, string);
        if (this.test(sb.toString())) {
            super.insertString(fb, offset, string, attr);
        }
    }

    private boolean test(String text) {
        Matcher matcher = this.ipAddressPattern.matcher(text);
        boolean found = matcher.find();
        return found;
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        Document doc = fb.getDocument();
        StringBuilder sb = new StringBuilder();
        sb.append(doc.getText(0, doc.getLength()));
        sb.replace(offset, offset + length, text);
        if (this.test(sb.toString())) {
            super.replace(fb, offset, length, text, attrs);
        }
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        Document doc = fb.getDocument();
        StringBuilder sb = new StringBuilder();
        sb.append(doc.getText(0, doc.getLength()));
        sb.delete(offset, offset + length);
        if (this.test(sb.toString())) {
            super.remove(fb, offset, length);
        }
    }
}

