/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui;

import com.integ.supporter.ui.CheckBoxNodeData;
import com.integ.supporter.ui.CheckBoxNodePanel;
import com.integ.supporter.ui.CheckBoxNodeRenderer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class CheckBoxNodeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private final CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
    private CheckBoxNodeData checkBoxNodeData;
    private final JTree theTree;

    public CheckBoxNodeEditor(JTree tree) {
        this.theTree = tree;
    }

    @Override
    public Object getCellEditorValue() {
        CheckBoxNodePanel panel = this.renderer.getPanel();
        this.checkBoxNodeData.setChecked(panel.check.isSelected());
        return this.checkBoxNodeData;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (!(event instanceof MouseEvent)) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        TreePath path = this.theTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (path == null) {
            return false;
        }
        Object node = path.getLastPathComponent();
        if (!(node instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Object userObject = treeNode.getUserObject();
        return userObject instanceof CheckBoxNodeData;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        this.checkBoxNodeData = (CheckBoxNodeData)treeNode.getUserObject();
        Component editor = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CheckBoxNodeEditor.this.stopCellEditing()) {
                    CheckBoxNodeEditor.this.fireEditingStopped();
                }
            }
        };
        if (editor instanceof CheckBoxNodePanel) {
            CheckBoxNodePanel panel = (CheckBoxNodePanel)editor;
            panel.check.addItemListener(itemListener);
        }
        return editor;
    }
}

