/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.janoslib.collections.NameValuePair;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.cinema.Device;
import com.integ.supporter.cinema.DeviceTypeModel;
import com.integ.supporter.cinema.devices.DeviceInfo;
import com.integ.supporter.cinema.devices.EthernetDeviceInfo;
import com.integ.supporter.cinema.devices.SerialDeviceInfo;
import com.integ.supporter.documentfilters.IpAddressDocumentFilter;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DevicePane
extends JPanel {
    private static final DeviceInfo[] KNOWN_DEVICES = new DeviceInfo[]{new EthernetDeviceInfo("BARCO", -1), new EthernetDeviceInfo("BARCO SERIES 1", 43680), new EthernetDeviceInfo("BARCO SERIES 2", 43728), new EthernetDeviceInfo("BARCO SERIES 4", 43731), new EthernetDeviceInfo("CHRISTIE", 5000), new EthernetDeviceInfo("NEC", 5000), new EthernetDeviceInfo("NEC SERIES 2", 43728), new EthernetDeviceInfo("USL JSD100 ETHERNET", 10001), new EthernetDeviceInfo("DOLBY CP650 ETHERNET", 61412), new EthernetDeviceInfo("DOLBY CP750 ETHERNET", 61408), new EthernetDeviceInfo("DOLBY CP850 ETHERNET", 61408), new EthernetDeviceInfo("DOLBY 3D DFC100 ETHERNET", 61412), new EthernetDeviceInfo("QSC DCP300 ETHERNET", 4446), new EthernetDeviceInfo("RAW ETHERNET", 0), new EthernetDeviceInfo("RAW UDP", 0), new SerialDeviceInfo("NEC VT700 SERIAL"), new SerialDeviceInfo("DOLBY CP650 SERIAL"), new SerialDeviceInfo("DOLBY CP750 SERIAL"), new SerialDeviceInfo("DOLBY CP850"), new SerialDeviceInfo("DOLBY 3D DFC100 SERIAL"), new SerialDeviceInfo("RAW SERIAL"), new EthernetDeviceInfo("HTTP Request", 80)};
    private Device _device;
    private boolean _valid;
    private JComboBox<String> baudRateDropDown;
    private JComboBox<String> dataBitsDropDown;
    private JComboBox<Object> deviceTypeDropDown;
    private JPanel deviceTypeOptionsPanel;
    private JPanel ethernetPanel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JComboBox<String> parityDropDown;
    private JComboBox<String> portDropDown;
    private JPanel serialPanel;
    private JComboBox<String> stopBitsDropDown;
    private JComboBox<String> terminationStringDropDown;
    private JPanel terminationStringPanel;
    private JTextField txtIpAddress;
    private JTextField txtName;
    private JTextField txtPort;

    public DevicePane() {
        this.initComponents();
        DeviceTypeModel model = new DeviceTypeModel();
        this.deviceTypeDropDown.setModel(model);
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(() -> {
                    String text = DevicePane.this.txtName.getText();
                    if (text.contains(" ")) {
                        DevicePane.this.txtName.setText(text.replace(" ", "_"));
                    }
                });
                this.update();
            }

            public void update() {
                DevicePane.this._device.setName(DevicePane.this.txtName.getText());
                DevicePane.this.validate();
            }
        });
        PlainDocument txtIpAddressDocument = (PlainDocument)this.txtIpAddress.getDocument();
        txtIpAddressDocument.setDocumentFilter(new IpAddressDocumentFilter());
        txtIpAddressDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void update() {
                DevicePane.this._device.setIpAddress(DevicePane.this.txtIpAddress.getText());
                DevicePane.this.validate();
            }
        });
        this.txtPort.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if ('0' > e.getKeyChar() || '9' < e.getKeyChar()) {
                    e.consume();
                }
            }
        });
        this.txtPort.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setEthernetPort(DevicePane.this.txtPort.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                System.out.println("txtPort.getText() = " + DevicePane.this.txtPort.getText());
                System.out.println("e = " + e);
                this.setEthernetPort(DevicePane.this.txtPort.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    System.out.println("txtPort.getText() = " + DevicePane.this.txtPort.getText());
                    System.out.println("e = " + e);
                    this.setEthernetPort(DevicePane.this.txtPort.getDocument().getText(0, e.getLength()));
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(DevicePane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            private void setEthernetPort(String ethernetPort) {
                DevicePane.this._device.setEthernetPort(ethernetPort);
            }
        });
        this.terminationStringDropDown.addActionListener(e -> this._device.setTerminationString((String)this.terminationStringDropDown.getSelectedItem()));
        this.portDropDown.addActionListener(e -> this._device.setSerialPort((String)this.portDropDown.getSelectedItem()));
        this.parityDropDown.addActionListener(e -> this._device.setBaudRate((String)this.parityDropDown.getSelectedItem()));
        this.dataBitsDropDown.addActionListener(e -> this._device.setDataBits((String)this.dataBitsDropDown.getSelectedItem()));
        this.stopBitsDropDown.addActionListener(e -> this._device.setStopBits((String)this.stopBitsDropDown.getSelectedItem()));
        this.parityDropDown.addActionListener(e -> this._device.setParity((String)this.parityDropDown.getSelectedItem()));
    }

    public Device getDevice() {
        return this._device;
    }

    public DevicePane(Device device) {
        this();
        this._device = device;
        try {
            this.txtName.setText(device.getName());
            String deviceType = device.getType();
            if ("barco".equalsIgnoreCase(deviceType)) {
                // empty if block
            }
            DeviceTypeModel model = (DeviceTypeModel)this.deviceTypeDropDown.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                NameValuePair nameValuePair = (NameValuePair)model.getElementAt(i);
                if (!nameValuePair.getName().equalsIgnoreCase(deviceType)) continue;
                this.deviceTypeDropDown.setSelectedIndex(i);
                break;
            }
            this.txtIpAddress.setText(device.getIpAddress());
            this.txtPort.setText(device.getEthernetPort());
            this.baudRateDropDown.setSelectedItem(device.getBaudRate());
            this.terminationStringDropDown.setSelectedItem(device.getTerminationString());
        }
        catch (Exception ex) {
            NotificationCollection.addError(ex);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtName = new JTextField();
        this.jLabel2 = new JLabel();
        this.deviceTypeDropDown = new JComboBox();
        this.terminationStringPanel = new JPanel();
        this.deviceTypeOptionsPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.serialPanel = new JPanel();
        this.jLabel10 = new JLabel();
        this.portDropDown = new JComboBox();
        this.jLabel3 = new JLabel();
        this.baudRateDropDown = new JComboBox();
        this.jLabel4 = new JLabel();
        this.dataBitsDropDown = new JComboBox();
        this.stopBitsDropDown = new JComboBox();
        this.jLabel8 = new JLabel();
        this.parityDropDown = new JComboBox();
        this.jLabel9 = new JLabel();
        this.ethernetPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.txtIpAddress = new JTextField();
        this.jLabel6 = new JLabel();
        this.txtPort = new JTextField();
        this.jLabel7 = new JLabel();
        this.terminationStringDropDown = new JComboBox();
        this.jLabel1.setText("Name");
        this.txtName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DevicePane.this.txtNameKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Type");
        this.deviceTypeDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePane.this.deviceTypeDropDownActionPerformed(evt);
            }
        });
        this.terminationStringPanel.setOpaque(false);
        GroupLayout terminationStringPanelLayout = new GroupLayout(this.terminationStringPanel);
        this.terminationStringPanel.setLayout(terminationStringPanelLayout);
        terminationStringPanelLayout.setHorizontalGroup(terminationStringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 194, Short.MAX_VALUE));
        terminationStringPanelLayout.setVerticalGroup(terminationStringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 22, Short.MAX_VALUE));
        this.deviceTypeOptionsPanel.setOpaque(false);
        this.deviceTypeOptionsPanel.setLayout(new CardLayout());
        this.jPanel2.setName("");
        this.jPanel2.setOpaque(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 465, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        this.deviceTypeOptionsPanel.add((Component)this.jPanel2, "Blank");
        this.serialPanel.setOpaque(false);
        this.jLabel10.setText("Port");
        this.portDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"AUX", "RS232"}));
        this.portDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePane.this.portDropDownActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Baud");
        this.baudRateDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"110", "300", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200"}));
        this.baudRateDropDown.setSelectedIndex(5);
        this.baudRateDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePane.this.baudRateDropDownActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Data Bits");
        this.dataBitsDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"7", "8"}));
        this.dataBitsDropDown.setSelectedIndex(1);
        this.dataBitsDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePane.this.dataBitsDropDownActionPerformed(evt);
            }
        });
        this.stopBitsDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "1.5", "2"}));
        this.stopBitsDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePane.this.stopBitsDropDownActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Stop Bits");
        this.parityDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Even", "Odd"}));
        this.parityDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePane.this.parityDropDownActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Parity");
        GroupLayout serialPanelLayout = new GroupLayout(this.serialPanel);
        this.serialPanel.setLayout(serialPanelLayout);
        serialPanelLayout.setHorizontalGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(serialPanelLayout.createSequentialGroup().addContainerGap().addGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portDropDown, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.baudRateDropDown, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(serialPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addGap(227, 227, 227).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.parityDropDown, -2, -1, -2)).addGroup(serialPanelLayout.createSequentialGroup().addComponent(this.dataBitsDropDown, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopBitsDropDown, -2, 55, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        serialPanelLayout.setVerticalGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(serialPanelLayout.createSequentialGroup().addGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portDropDown, -2, -1, -2).addComponent(this.baudRateDropDown, -2, -1, -2).addComponent(this.dataBitsDropDown, -2, -1, -2).addComponent(this.stopBitsDropDown, -2, -1, -2)).addContainerGap()).addGroup(serialPanelLayout.createSequentialGroup().addGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.parityDropDown, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        this.deviceTypeOptionsPanel.add((Component)this.serialPanel, "Serial");
        this.ethernetPanel.setOpaque(false);
        this.jLabel5.setText("IP Address");
        this.txtIpAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePane.this.txtIpAddressActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Port");
        GroupLayout ethernetPanelLayout = new GroupLayout(this.ethernetPanel);
        this.ethernetPanel.setLayout(ethernetPanelLayout);
        ethernetPanelLayout.setHorizontalGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ethernetPanelLayout.createSequentialGroup().addContainerGap().addGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtIpAddress, -2, 87, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.txtPort, -2, -1, -2)).addContainerGap(302, Short.MAX_VALUE)));
        ethernetPanelLayout.setVerticalGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ethernetPanelLayout.createSequentialGroup().addGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPort, -2, -1, -2).addComponent(this.txtIpAddress, -2, -1, -2)).addGap(0, 6, Short.MAX_VALUE)));
        this.deviceTypeOptionsPanel.add((Component)this.ethernetPanel, "Ethernet");
        this.jLabel7.setText("Termination String");
        this.terminationStringDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "\\r", "\\n", "\\r\\n"}));
        this.terminationStringDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePane.this.terminationStringDropDownActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtName, -2, 194, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deviceTypeDropDown, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.terminationStringDropDown, -2, -1, -2).addGap(18, 18, 18).addComponent(this.terminationStringPanel, -2, -1, -2)).addComponent(this.jLabel7)).addGap(24, 24, 24).addComponent(this.deviceTypeOptionsPanel, -2, 465, -2).addContainerGap(99, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtName, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deviceTypeDropDown, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.terminationStringDropDown, -2, -1, -2).addComponent(this.terminationStringPanel, -2, -1, -2)))).addComponent(this.deviceTypeOptionsPanel, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)));
    }

    private void deviceTypeDropDownActionPerformed(ActionEvent evt) {
        this.deviceTypeChanged();
        String selectedDeviceType = this.deviceTypeDropDown.getSelectedItem().toString();
        if ("BARCO".equals(selectedDeviceType) && 0 != evt.getModifiers()) {
            String[] options = new String[]{"BARCO Series 1", "BARCO Series 2", "BARCO Series 4"};
            JList<String> list = new JList<String>(options);
            int result = JOptionPane.showConfirmDialog(null, list, "Select an Option", 2, -1);
            System.out.println("result = " + result);
            DeviceInfo deviceInfo = null;
            selectedDeviceType = list.getSelectedValue();
            for (int i = 0; i < KNOWN_DEVICES.length; ++i) {
                if (!KNOWN_DEVICES[i].getName().equalsIgnoreCase(selectedDeviceType)) continue;
                deviceInfo = KNOWN_DEVICES[i];
            }
            System.out.println("deviceInfo = " + deviceInfo);
            this.deviceTypeChanged(deviceInfo);
        }
    }

    private void deviceTypeChanged() {
        String selectedDeviceType = this.deviceTypeDropDown.getSelectedItem().toString();
        this._device.setType(selectedDeviceType);
        DeviceInfo deviceInfo = null;
        for (int i = 0; i < KNOWN_DEVICES.length; ++i) {
            if (!KNOWN_DEVICES[i].getName().equalsIgnoreCase(selectedDeviceType)) continue;
            deviceInfo = KNOWN_DEVICES[i];
        }
        this.deviceTypeChanged(deviceInfo);
    }

    private void deviceTypeChanged(DeviceInfo deviceInfo) {
        CardLayout cardLayout = (CardLayout)this.deviceTypeOptionsPanel.getLayout();
        if (null == deviceInfo) {
            cardLayout.show(this.deviceTypeOptionsPanel, "Blank");
        } else if (2 == deviceInfo.getDeviceType()) {
            cardLayout.show(this.deviceTypeOptionsPanel, "Ethernet");
            if (null != this._device) {
                if (0 < ((EthernetDeviceInfo)deviceInfo).getPort()) {
                    this.txtPort.setText(String.valueOf(((EthernetDeviceInfo)deviceInfo).getPort()));
                } else {
                    this.txtPort.setText(String.valueOf(this._device.getEthernetPort()));
                }
            } else if (deviceInfo instanceof EthernetDeviceInfo) {
                this.txtPort.setText(String.valueOf(((EthernetDeviceInfo)deviceInfo).getPort()));
            }
        } else if (1 == deviceInfo.getDeviceType()) {
            cardLayout.show(this.deviceTypeOptionsPanel, "Serial");
        }
        this.deviceTypeOptionsPanel.updateUI();
        this.terminationStringPanel.setVisible(false);
    }

    private void parityDropDownActionPerformed(ActionEvent evt) {
        this._device.setParity((String)this.parityDropDown.getSelectedItem());
    }

    private void terminationStringDropDownActionPerformed(ActionEvent evt) {
        this._device.setTerminationString((String)this.terminationStringDropDown.getSelectedItem());
    }

    private void portDropDownActionPerformed(ActionEvent evt) {
        if (this.deviceTypeOptionsPanel.getComponent(0) == this.ethernetPanel) {
            this._device.setEthernetPort((String)this.portDropDown.getSelectedItem());
        } else if (this.deviceTypeOptionsPanel.getComponent(0) == this.serialPanel) {
            this._device.setSerialPort((String)this.portDropDown.getSelectedItem());
        }
    }

    private void baudRateDropDownActionPerformed(ActionEvent evt) {
        this._device.setBaudRate((String)this.baudRateDropDown.getSelectedItem());
    }

    private void dataBitsDropDownActionPerformed(ActionEvent evt) {
        this._device.setDataBits((String)this.dataBitsDropDown.getSelectedItem());
    }

    private void stopBitsDropDownActionPerformed(ActionEvent evt) {
        this._device.setStopBits((String)this.stopBitsDropDown.getSelectedItem());
    }

    private void txtIpAddressActionPerformed(ActionEvent evt) {
    }

    private void txtNameKeyTyped(KeyEvent evt) {
        if (' ' == evt.getKeyChar()) {
            evt.setKeyChar('_');
        }
    }
}

