/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.supporter.cinema.devices.CinemaDevice;
import java.util.Random;

public class MacroAction {
    private final int _instanceHash = new Random().nextInt() & 0xFFFFFFFF;
    private String _name;
    private CinemaDevice _cinemaDevice;
    private String _cinemaDeviceName = "";
    private String _action = "";
    private String _data = "";

    public int hashCode() {
        return this._instanceHash;
    }

    public MacroAction(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public CinemaDevice getDevice() {
        return this._cinemaDevice;
    }

    public void setDevice(CinemaDevice cinemaDevice) {
        this._cinemaDevice = cinemaDevice;
    }

    public String getDeviceName() {
        return this._cinemaDeviceName;
    }

    public void setDeviceName(String cinemaDeviceName) {
        if ("null".equalsIgnoreCase(cinemaDeviceName)) {
            cinemaDeviceName = "";
        }
        this._cinemaDeviceName = cinemaDeviceName;
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        if ("null".equalsIgnoreCase(action)) {
            action = "";
        }
        this._action = action;
    }

    public String getData() {
        return this._data;
    }

    public void setData(String data) {
        if ("null".equalsIgnoreCase(data)) {
            data = "";
        }
        this._data = data;
    }

    public String getDescription() {
        if (null == this._cinemaDevice && null == this._cinemaDeviceName) {
            return "Device not defined";
        }
        String cinemaDeviceName = this._cinemaDeviceName;
        if (null != this._cinemaDevice) {
            cinemaDeviceName = this._cinemaDevice.toString();
        }
        if (null == this._action) {
            return String.format("Action for '%s' not selected", this._cinemaDevice.toString());
        }
        if (null == this._data) {
            return String.format("%s action for %s has not been defined", this._action, this._cinemaDevice.toString());
        }
        return cinemaDeviceName + " " + this._action + " " + this._data;
    }

    public String getDeviceType() {
        return this._cinemaDevice.toString().getClass().getName();
    }

    public String getNameWithDeviceType() {
        if (null != this._cinemaDevice) {
            return this._name + " (" + this.getDeviceType().replaceAll(" ", "_") + ")";
        }
        return this._name;
    }

    public Object clone() {
        MacroAction newMacroAction = new MacroAction(this._name);
        newMacroAction.setAction(this._action);
        newMacroAction.setDevice(this._cinemaDevice);
        newMacroAction.setData(this._data);
        return newMacroAction;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof MacroAction)) {
            return false;
        }
        MacroAction macroActionToCompareTo = (MacroAction)obj;
        return this.hashCode() == macroActionToCompareTo.hashCode();
    }
}

