/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.PathUtils;
import com.integ.supporter.BackgroundAction;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.dialogs.LoginDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamAdapter;

public class CinemaFilePublisher
extends BackgroundAction {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm:ss.SSS");
    private final File _localFile;
    private final String _remoteFolderPath;
    private final String _remoteFilePath;
    private FilenameFilter _filenameFilter;
    private FTPFile[] _fileEntries;

    public CinemaFilePublisher(JniorInfo jniorInfo, String localFilePath, String remoteFolderPath) {
        super(jniorInfo);
        this._localFile = new File(localFilePath);
        this._remoteFolderPath = remoteFolderPath;
        this._remoteFilePath = remoteFolderPath + this._localFile.getName();
    }

    @Override
    public String getTitle() {
        return String.format("Publishing %s to %s", this._localFile.getName(), super.getJniorInfo().IpAddress);
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this._filenameFilter = filenameFilter;
    }

    @Override
    public void run() {
        try {
            if (null == super.getJniorInfo()) {
                return;
            }
            FTPClient ftpClient = new FTPClient();
            ftpClient.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out)));
            CopyStreamAdapter streamListener = new CopyStreamAdapter(){

                @Override
                public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                    int percent = (int)(totalBytesTransferred * 100L / CinemaFilePublisher.this._localFile.length());
                    CinemaFilePublisher.this.update(String.format("uploading %s", CinemaFilePublisher.this._remoteFilePath), percent);
                }
            };
            ftpClient.setCopyStreamListener(streamListener);
            super.update("Connecting to FTP Server");
            ftpClient.connect(super.getJniorInfo().IpAddress, 21);
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                ftpClient.disconnect();
                throw new IOException("Exception in connecting to FTP Server");
            }
            super.update("Logging in to FTP Server");
            if (!ftpClient.login(super.getJniorInfo().Username, super.getJniorInfo().Password)) {
                LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
                loginDialog.setDescription("Get credentials for " + this.getJniorInfo().IpAddress);
                loginDialog.centerParent();
                loginDialog.setVisible(true);
                if (loginDialog.getResult() == 1) {
                    this.getJniorInfo().Username = loginDialog.getUsername();
                    this.getJniorInfo().Password = loginDialog.getPassword();
                    if (!ftpClient.login(this.getJniorInfo().Username, this.getJniorInfo().Password)) {
                        super.update("Unable to login to ftp server");
                        throw new RuntimeException("unable to login to ftp server for " + this.getJniorInfo().IpAddress);
                    }
                } else {
                    super.update("User cancelled providing new credentials");
                    Thread.sleep(2000L);
                    this.complete();
                    return;
                }
            }
            String newFileMd5 = FileUtils.getFileMd5(this._localFile.getPath());
            boolean fileNeeded = true;
            super.update("Checking for Device or Macro Files");
            ArrayList deviceFiles = new ArrayList();
            this._fileEntries = ftpClient.listFiles(this._remoteFolderPath);
            String cinemaFilePath = this.fileExists(this._filenameFilter);
            if (null != cinemaFilePath) {
                String fileName = cinemaFilePath.substring(cinemaFilePath.lastIndexOf("/") + 1);
                File tempFile = new File(PathUtils.combine(Constants.TEMP_DIRECTORY, fileName));
                FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
                boolean result = ftpClient.retrieveFile(cinemaFilePath, fileOutputStream);
                String tempFileMd5 = FileUtils.getFileMd5(tempFile.getPath());
                boolean bl = fileNeeded = !tempFileMd5.equalsIgnoreCase(newFileMd5);
                if (fileNeeded) {
                    SimpleDateFormat sdf = new SimpleDateFormat("YYMMddHHmm");
                    String bakFilePath = String.format("/flash/cinema_backup/%s_%s", sdf.format(System.currentTimeMillis()), fileName);
                    FileInputStream tempFileInputStream = new FileInputStream(tempFile);
                    boolean storeBakFileResult = ftpClient.storeFile(bakFilePath, tempFileInputStream);
                    System.out.println("storeBakFileResult = " + storeBakFileResult);
                    ftpClient.deleteFile(cinemaFilePath);
                } else {
                    super.update(fileName + " is not neeeded");
                    this.complete();
                    return;
                }
            }
            String cinemaLogPath = this.fileExists((dir, name) -> name.equals("cinema.log"));
            Date lastTimestamp = null;
            if (null != cinemaLogPath) {
                InputStream in = ftpClient.retrieveFileStream("/cinema.log");
                String cinemaLogFileContent = new String(in.readAllBytes());
                System.out.println("cinemaLogFileContent = " + cinemaLogFileContent);
                ftpClient.completePendingCommand();
                String[] lines = cinemaLogFileContent.split("\\r\\n");
                String lastLine = lines[lines.length - 1];
                String timestampString = lastLine.substring(0, lastLine.indexOf(","));
                lastTimestamp = SIMPLE_DATE_FORMAT.parse(timestampString);
                System.out.println("lastTimestamp = " + lastTimestamp);
            }
            if (fileNeeded) {
                FileInputStream fin = new FileInputStream(this._localFile.getPath());
                boolean uploadResult = ftpClient.storeFile(this._remoteFilePath, fin);
                System.out.println("uploadResult = " + uploadResult);
                if (!uploadResult) {
                    throw new RuntimeException("unable to upload " + this._remoteFilePath);
                }
            }
            super.update(this._remoteFilePath + " uploaded");
            if (null != cinemaLogPath) {
                long timeout = System.currentTimeMillis() + 45000L;
                boolean fileProcessed = false;
                while (!fileProcessed) {
                    String[] lines;
                    if (System.currentTimeMillis() > timeout) {
                        throw new RuntimeException("publish timed out while waiting for the file to be injested");
                    }
                    Thread.sleep(5000L);
                    InputStream in = ftpClient.retrieveFileStream("/cinema.log");
                    String cinemaLogFileContent = new String(in.readAllBytes());
                    System.out.println("cinemaLogFileContent = " + cinemaLogFileContent);
                    ftpClient.completePendingCommand();
                    for (String line : lines = cinemaLogFileContent.split("\\r\\n")) {
                        System.out.println("line = " + line);
                        String timestampString = line.substring(0, line.indexOf(","));
                        Date timestamp = SIMPLE_DATE_FORMAT.parse(timestampString);
                        if (!timestamp.after(lastTimestamp)) continue;
                        timeout = System.currentTimeMillis() + 15000L;
                        super.update("Processing: " + line);
                        if (!line.toLowerCase().endsWith("file loaded")) continue;
                        Thread.sleep(5000L);
                        fileProcessed = true;
                    }
                }
            }
        }
        catch (Exception ex) {
            super.update("ERROR: " + ex.getMessage());
            NotificationCollection.addError(String.format("error uploading %s to %s", this._localFile.getPath(), super.getJniorInfo().toString()), ex);
        }
        this.complete();
    }

    private String fileExists(FilenameFilter filenameFilter) {
        for (FTPFile fileEntry : this._fileEntries) {
            if (!filenameFilter.accept(new File(this._remoteFolderPath), fileEntry.getName())) continue;
            String filePath = this._remoteFolderPath + fileEntry.getName();
            return filePath;
        }
        return null;
    }
}

