/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net.beacon;

import com.integ.janoslib.net.beacon.JniorCollectionListener;
import com.integ.janoslib.net.beacon.JniorCollectionListeners;
import com.integ.janoslib.net.beacon.JniorInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class JniorCollection {
    private static final Hashtable<Integer, JniorInfo> JNIORS_BY_SERIAL = new Hashtable();
    private static final JniorCollectionListeners LISTENERS = new JniorCollectionListeners();

    public static void addListener(JniorCollectionListener listener) {
        LISTENERS.add(listener);
    }

    public static void removeListener(JniorCollectionListener listener) {
        LISTENERS.remove(listener);
    }

    public static int getJniorCount() {
        return JNIORS_BY_SERIAL.size();
    }

    public static ArrayList<JniorInfo> getJniors() {
        ArrayList<JniorInfo> list = new ArrayList<JniorInfo>();
        Enumeration<JniorInfo> e = JNIORS_BY_SERIAL.elements();
        while (e.hasMoreElements()) {
            JniorInfo jniorInfo = e.nextElement();
            list.add(jniorInfo);
        }
        return list;
    }

    public static boolean contains(int serialNumber) {
        return JNIORS_BY_SERIAL.containsKey(serialNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JniorInfo getJniorInfoBySerialNumber(int serialNumber) {
        if (0 >= serialNumber) {
            return null;
        }
        Hashtable<Integer, JniorInfo> hashtable = JNIORS_BY_SERIAL;
        synchronized (hashtable) {
            JniorInfo jniorInfo;
            if (!JNIORS_BY_SERIAL.containsKey(serialNumber)) {
                jniorInfo = new JniorInfo(serialNumber);
                JNIORS_BY_SERIAL.put(serialNumber, jniorInfo);
                LISTENERS.fireJniorAdded(jniorInfo);
            } else {
                jniorInfo = JNIORS_BY_SERIAL.get(serialNumber);
            }
            return jniorInfo;
        }
    }
}

