/*
 * Decompiled with CFR 0.152.
 */
package com.integ.websocket.messages;

import com.integ.websocket.messages.JniorMessage;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;

public class Login
extends JniorMessage {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private final String _username;
    private final String _password;

    public Login(String username, String password, String nonce) {
        this._username = username;
        this._password = password;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update((username + ":" + nonce + ":" + password).getBytes());
            byte[] digest = md.digest();
            String digestString = Login.bytesToHex(digest);
            digestString = username + ":" + digestString;
            this.put("Auth-Digest", digestString);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getGlobal().severe(ex.getMessage());
        }
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

