/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.supporter.updater.steps.CleanupStep;
import com.integ.supporter.updater.steps.DeleteFileStep;
import com.integ.supporter.updater.steps.FtpStep;
import com.integ.supporter.updater.steps.LoadApplicationStep;
import com.integ.supporter.updater.steps.MkDirStep;
import com.integ.supporter.updater.steps.ProjectStep;
import com.integ.supporter.updater.steps.RebootStep;
import com.integ.supporter.updater.steps.RegistryStep;
import com.integ.supporter.updater.steps.TelnetStep;
import com.integ.supporter.updater.steps.UnknownStep;
import com.integ.supporter.updater.steps.UnknownStepException;
import com.integ.supporter.updater.steps.UpdateSeries3OSStep;
import com.integ.supporter.updater.steps.UpdateSeries4OSStep;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectStepFactory {
    public static ProjectStep getProjectStep(Element xmlElement) throws UnknownStepException {
        ProjectStepFactory.listAllAttributes(xmlElement);
        String type = xmlElement.getAttribute("xsi:type");
        System.out.println("Type: " + type);
        ProjectStep projectStep = null;
        switch (type) {
            case "UpdateJniorOSProperty": {
                projectStep = new UpdateSeries3OSStep(xmlElement);
                break;
            }
            case "UpdateSeries4OSProperty": {
                projectStep = new UpdateSeries4OSStep(xmlElement);
                break;
            }
            case "LoadFtpProperty": {
                projectStep = new FtpStep(xmlElement);
                break;
            }
            case "UpdateTaskManagerProperty": 
            case "UpdateSerialControlProperty": 
            case "UpdateSerialEthernetProperty": 
            case "LoadApplicationProperty": {
                projectStep = new LoadApplicationStep(xmlElement);
                break;
            }
            case "CleanupProperty": {
                projectStep = new CleanupStep(xmlElement);
                break;
            }
            case "MkDirFtpProperty": {
                projectStep = new MkDirStep(xmlElement);
                break;
            }
            case "DeleteFileProperty": {
                projectStep = new DeleteFileStep(xmlElement);
                break;
            }
            case "RebootProperty": {
                projectStep = new RebootStep(xmlElement);
                break;
            }
            case "TelnetProperty": {
                projectStep = new TelnetStep(xmlElement);
                break;
            }
            case "LoadRegistryProperty": {
                projectStep = new RegistryStep(xmlElement);
                break;
            }
            default: {
                projectStep = new UnknownStep(xmlElement);
            }
        }
        return projectStep;
    }

    public static void listAllAttributes(Element element) {
        System.out.println("List attributes for node: " + element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        int numAttrs = attributes.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            Attr attr = (Attr)attributes.item(i);
            String attrName = attr.getNodeName();
            String attrValue = attr.getNodeValue();
            System.out.println("Found attribute: " + attrName + " with value: " + attrValue);
        }
    }

    public static void listAllElements(Element element) {
        System.out.println("List elements for node: " + element.getNodeName());
        NodeList elements = element.getChildNodes();
        int numElements = elements.getLength();
        for (int i = 0; i < numElements; ++i) {
            Node node = elements.item(i);
            System.out.println("Found node: " + node);
        }
    }
}

