/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.beacon.JniorInfo;
import com.integ.supporter.JniorControlConnection;
import com.integ.supporter.updater.UpdateProjectExecutor;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.steps.ProjectStepFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ProjectStep {
    private Element _xmlElement;
    protected String _type;
    private String _name;
    private Boolean _checkedOnLoad;
    protected String _summary;
    protected UpdateProjectFile _updateProjectFile;
    protected UpdateProjectExecutor _updateProjectExecutor;
    protected Logger _logger = Logger.getGlobal();
    protected JniorInfo _jniorInfo;
    protected JniorControlConnection _jniorUpdateControlConnection;
    private boolean _isCheckedOnLoad = false;
    protected PropertyChangeSupport _changes = new PropertyChangeSupport(this);

    public ProjectStep(String name) {
        this._name = name;
    }

    public ProjectStep(Element xmlElement) {
        this._xmlElement = xmlElement;
        this._type = xmlElement.getAttribute("xsi:type");
        System.out.println("Type: " + this._type);
        this._name = xmlElement.getAttribute("Name");
        System.out.println("Name: " + this._name);
        this._checkedOnLoad = Boolean.valueOf(this.getChildNodeString("CheckedOnLoad"));
        System.out.println("CheckedOnLoad: " + this._checkedOnLoad);
        this._isCheckedOnLoad = this._checkedOnLoad;
    }

    public UpdateProjectFile getUpdateProjectFile() {
        return this._updateProjectFile;
    }

    public Element getXmlElement() {
        return this._xmlElement;
    }

    public Element getXmlElement(Document document) {
        Element xmlElement = document.createElement("LoadProperty");
        xmlElement.setAttribute("Name", this.getName());
        xmlElement.setAttribute("xsi:type", this.getType());
        Element checkedOnLoadElement = document.createElement("CheckedOnLoad");
        checkedOnLoadElement.appendChild(document.createTextNode(String.valueOf(this._isCheckedOnLoad)));
        xmlElement.appendChild(checkedOnLoadElement);
        return xmlElement;
    }

    public ProjectStep setUpdateProject(UpdateProjectFile updateProjectFile) {
        this._updateProjectFile = updateProjectFile;
        return this;
    }

    public ProjectStep setLogger(Logger logger) {
        this._logger = logger;
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changes.addPropertyChangeListener(propertyChangeListener);
    }

    public String getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        String oldValue = this._name;
        this._name = name;
        this._changes.firePropertyChange("Name", oldValue, this._name);
    }

    public boolean isCheckedOnLoad() {
        return this._isCheckedOnLoad;
    }

    public void setCheckedOnLoad(boolean checkedOnLoad) {
        boolean oldValue = this._isCheckedOnLoad;
        this._isCheckedOnLoad = checkedOnLoad;
        this._changes.firePropertyChange("CheckedOnLoad", oldValue, this._isCheckedOnLoad);
    }

    public void setExecutor(UpdateProjectExecutor updateProjectExecutor) {
        this._updateProjectExecutor = updateProjectExecutor;
    }

    protected final String getAttributeString(String attributeName) {
        try {
            return this._xmlElement.getAttribute(attributeName);
        }
        catch (Exception ex) {
            this._logger.severe(String.format("%s attribute not found in xmlElement", attributeName));
            return "";
        }
    }

    protected final String getChildNodeString(String elementName) {
        try {
            Element xmlChildElement = (Element)this._xmlElement.getElementsByTagName(elementName).item(0);
            String childValueString = xmlChildElement.getFirstChild().getNodeValue();
            return childValueString;
        }
        catch (Exception ex) {
            this._logger.severe(String.format("%s child element not found in xmlElement", elementName));
            return "";
        }
    }

    protected final String[] getChildNodeStrings(String elementName) {
        String[] strings = null;
        try {
            Element xmlChildElement = (Element)this._xmlElement.getElementsByTagName(elementName).item(0);
            ProjectStepFactory.listAllElements(xmlChildElement);
            NodeList childNodes = xmlChildElement.getElementsByTagName("string");
            int childNodeCount = childNodes.getLength();
            strings = new String[childNodeCount];
            for (int i = 0; i < childNodeCount; ++i) {
                String value;
                xmlChildElement = (Element)childNodes.item(i);
                strings[i] = value = xmlChildElement.getFirstChild().getNodeValue();
            }
        }
        catch (Exception ex) {
            this._logger.severe(String.format("%s not found in xmlElement", elementName));
        }
        return strings;
    }

    public String toString() {
        return this._name;
    }

    public void setJniorInfo(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
    }

    public void setJniorUpdateControlConnection(JniorControlConnection jniorUpdateControlConnection) {
        this._jniorUpdateControlConnection = jniorUpdateControlConnection;
    }

    public abstract boolean execute() throws Exception;

    public String getSummary() {
        return this._summary;
    }
}

