/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.syntaxhighlight;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.RollingLog;
import com.integ.supporter.ui.syntaxhighlight.StyleRegion;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class JniorSyntaxView
extends PlainView {
    private static final Logger LOGGER = RollingLog.getLogger("JniorSyntaxView");
    private static final String CRITICAL_PATTERN_STRING = "assertion|terminating|dump|reformatted";
    private static final Pattern CRITICAL_PATTERN = Pattern.compile("assertion|terminating|dump|reformatted", 2);
    private static final SimpleAttributeSet CRITICAL_ATTRIBUTES = new SimpleAttributeSet();
    private static final String EXCEPTION_PATTERN_STRING = "exception|error";
    private static final Pattern EXCEPTION_PATTERN = Pattern.compile("exception|error", 2);
    private static final SimpleAttributeSet EXCEPTION_ATTRIBUTES = new SimpleAttributeSet();
    private static final String WARNING_PATTERN_STRING = "warn(ing)?|failed|login incorrect|unable to start";
    private static final Pattern WARNING_PATTERN = Pattern.compile("warn(ing)?|failed|login incorrect|unable to start", 2);
    private static final SimpleAttributeSet WARNING_ATTRIBUTES = new SimpleAttributeSet();
    private static final String GOOD_PATTERN_STRING = "initialized|256-bit encrypted connection|keys generated|certificate updated";
    private static final Pattern GOOD_PATTERN = Pattern.compile("initialized|256-bit encrypted connection|keys generated|certificate updated", 2);
    private static final SimpleAttributeSet GOOD_ATTRIBUTES = new SimpleAttributeSet();
    private static final String LOGIN_PATTERN_STRING = "login: |password: ";
    private static final Pattern LOGIN_PATTERN = Pattern.compile("login: |password: ", 2);
    private static final String PROMPT_PATTERN_STRING = "^\\b[\\w-]+ (\\/\\w*)+>";
    private static final Pattern PROMPT_PATTERN = Pattern.compile("^\\b[\\w-]+ (\\/\\w*)+>", 2);
    private static final SimpleAttributeSet PROMPT_ATTRIBUTES = new SimpleAttributeSet();
    private static final Color SALMON_COLOR = Color.decode("#fa8072");
    private static final Color PALE_GREEN_COLOR = Color.decode("#98FB98");
    private static final Color ALMOST_YELLOW_COLOR = Color.decode("#ffff40");

    public JniorSyntaxView(Element element) {
        super(element);
        this.getDocument().putProperty("tabSize", 4);
    }

    private StyleRegion checkForCritical(String text, int start, int end) {
        long elapsed;
        long startTime = System.currentTimeMillis();
        StyleRegion styleRegion = null;
        Matcher matcher = CRITICAL_PATTERN.matcher(text.substring(start, end));
        if (matcher.find()) {
            styleRegion = new StyleRegion(start, end, CRITICAL_ATTRIBUTES);
        }
        if (10L < (elapsed = System.currentTimeMillis() - startTime)) {
            System.out.println("checkForCritical took " + (double)elapsed / 1000.0);
        }
        return styleRegion;
    }

    private StyleRegion checkForException(String text, int start, int end) {
        long elapsed;
        long startTime = System.currentTimeMillis();
        StyleRegion styleRegion = null;
        Matcher matcher = EXCEPTION_PATTERN.matcher(text.substring(start, end));
        if (matcher.find()) {
            styleRegion = new StyleRegion(start, end, EXCEPTION_ATTRIBUTES);
        }
        if (10L < (elapsed = System.currentTimeMillis() - startTime)) {
            System.out.println("checkForException took " + (double)elapsed / 1000.0);
        }
        return styleRegion;
    }

    private StyleRegion checkForWarning(String text, int start, int end) {
        long elapsed;
        long startTime = System.currentTimeMillis();
        StyleRegion styleRegion = null;
        Matcher matcher = WARNING_PATTERN.matcher(text.substring(start, end));
        if (matcher.find()) {
            styleRegion = new StyleRegion(start, end, WARNING_ATTRIBUTES);
        }
        if (10L < (elapsed = System.currentTimeMillis() - startTime)) {
            System.out.println("checkForWarning took " + (double)elapsed / 1000.0);
        }
        return styleRegion;
    }

    private StyleRegion checkForGood(String text, int start, int end) {
        long elapsed;
        long startTime = System.currentTimeMillis();
        StyleRegion styleRegion = null;
        Matcher matcher = GOOD_PATTERN.matcher(text.substring(start, end));
        if (matcher.find()) {
            styleRegion = new StyleRegion(start, end, GOOD_ATTRIBUTES);
        }
        if (10L < (elapsed = System.currentTimeMillis() - startTime)) {
            System.out.println("checkForGood took " + (double)elapsed / 1000.0);
        }
        return styleRegion;
    }

    private StyleRegion checkForPrompt(String text, int start, int end) {
        long elapsed;
        long startTime = System.currentTimeMillis();
        StyleRegion styleRegion = null;
        Matcher matcher = LOGIN_PATTERN.matcher(text.substring(start, end));
        if (matcher.find()) {
            styleRegion = new StyleRegion(start, matcher.end(0), PROMPT_ATTRIBUTES);
        }
        if (null == styleRegion && (matcher = PROMPT_PATTERN.matcher(text.substring(start, end))).find()) {
            styleRegion = new StyleRegion(start, matcher.end(0), PROMPT_ATTRIBUTES);
        }
        if (10L < (elapsed = System.currentTimeMillis() - startTime)) {
            System.out.println("checkForPrompt took " + (double)elapsed / 1000.0);
        }
        return styleRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
        long totalElapsed;
        String text;
        long startTime;
        block15: {
            startTime = System.currentTimeMillis();
            Document doc = this.getDocument();
            text = doc.getText(p0, p1 - p0);
            try {
                Segment segment = new Segment();
                ArrayList<Object> styleRegionList = new ArrayList<Object>();
                int segmentStart = p0;
                while (p1 > segmentStart) {
                    doc.getText(segmentStart, p1 - segmentStart, segment);
                    String line = segment.toString();
                    Object styleRegion = null;
                    styleRegion = this.checkForCritical(line, 0, line.length());
                    if (null != styleRegion || null != (styleRegion = this.checkForException(line, 0, line.length())) || null != (styleRegion = this.checkForWarning(line, 0, line.length())) || null != (styleRegion = this.checkForGood(line, 0, line.length())) || null != (styleRegion = this.checkForPrompt(line, 0, line.length()))) {
                        // empty if block
                    }
                    if (null == styleRegion) {
                        segmentStart = p1;
                        continue;
                    }
                    styleRegionList.add(styleRegion);
                    segmentStart = p0 + ((StyleRegion)styleRegion).getEndPos() + 1;
                }
                int i = 0;
                for (StyleRegion styleRegion : styleRegionList) {
                    SimpleAttributeSet attributeSet;
                    int start = styleRegion.getStartPos();
                    int end = styleRegion.getEndPos();
                    if (i < start) {
                        JTextComponent tc = (JTextComponent)this.getContainer();
                        Color foregroundColor = tc.getForeground();
                        graphics.setColor(foregroundColor);
                        Font font = graphics.getFont();
                        font = new Font(font.getFamily(), 0, font.getSize());
                        graphics.setFont(font);
                        doc.getText(p0 + i, start - i, segment);
                        x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
                    }
                    int fontWeight = StyleConstants.isBold(attributeSet = styleRegion.getAttributeSet()) ? 1 : 0;
                    int fontSize = StyleConstants.getFontSize(attributeSet);
                    Font font = graphics.getFont();
                    font = new Font(font.getFamily(), fontWeight, fontSize);
                    graphics.setFont(font);
                    i = end;
                    doc.getText(p0 + start, i - start, segment);
                    graphics.setColor(StyleConstants.getForeground(attributeSet));
                    x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, start);
                }
                if (i >= text.length()) break block15;
                JTextComponent tc = (JTextComponent)this.getContainer();
                Color color = tc.getForeground();
                graphics.setColor(color);
                Font font = graphics.getFont();
                font = new Font(font.getFamily(), 0, font.getSize());
                graphics.setFont(font);
                doc.getText(p0 + i, text.length() - i, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
            }
            catch (Exception ex) {
                try {
                    LOGGER.severe(ExceptionUtils.getStackTrace(ex));
                }
                catch (Throwable throwable) {
                    long totalElapsed2 = System.currentTimeMillis() - startTime;
                    if (10L < totalElapsed2) {
                        String elapsedText = String.format("took %.2f to process unselected text: %s", (double)totalElapsed2 / 1000.0, text);
                        System.out.println(elapsedText);
                        if (50L < totalElapsed2) {
                            LOGGER.info(elapsedText);
                        }
                    }
                    throw throwable;
                }
                long totalElapsed3 = System.currentTimeMillis() - startTime;
                if (10L < totalElapsed3) {
                    String elapsedText = String.format("took %.2f to process unselected text: %s", (double)totalElapsed3 / 1000.0, text);
                    System.out.println(elapsedText);
                    if (50L < totalElapsed3) {
                        LOGGER.info(elapsedText);
                    }
                }
            }
        }
        if (10L < (totalElapsed = System.currentTimeMillis() - startTime)) {
            String elapsedText = String.format("took %.2f to process unselected text: %s", (double)totalElapsed / 1000.0, text);
            System.out.println(elapsedText);
            if (50L < totalElapsed) {
                LOGGER.info(elapsedText);
            }
        }
        return x;
    }

    static {
        StyleConstants.setForeground(CRITICAL_ATTRIBUTES, SALMON_COLOR);
        StyleConstants.setBold(CRITICAL_ATTRIBUTES, true);
        StyleConstants.setForeground(EXCEPTION_ATTRIBUTES, Color.ORANGE);
        StyleConstants.setBold(EXCEPTION_ATTRIBUTES, true);
        StyleConstants.setForeground(WARNING_ATTRIBUTES, ALMOST_YELLOW_COLOR);
        StyleConstants.setBold(WARNING_ATTRIBUTES, true);
        StyleConstants.setForeground(GOOD_ATTRIBUTES, PALE_GREEN_COLOR);
        StyleConstants.setBold(GOOD_ATTRIBUTES, true);
        StyleConstants.setForeground(PROMPT_ATTRIBUTES, Color.CYAN);
        StyleConstants.setBold(PROMPT_ATTRIBUTES, true);
    }
}

