/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.FileUtils;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.beacon.RemoteFileListener;
import com.integ.supporter.ui.TextDialog;
import com.integ.supporter.ui.syntaxhighlight.JniorSyntaxEditorKit;
import java.awt.Frame;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class RemoteFileTextDialog
extends TextDialog {
    private static final SimpleDateFormat FOLDER_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private RemoteFileListener _remoteFileListener = null;
    private boolean _scrollToEnd;

    public RemoteFileTextDialog(Frame parent, boolean modal) {
        super(parent, modal);
        super.getTextPane().setEditorKit(new JniorSyntaxEditorKit());
    }

    public void setScrollToEnd() {
        this._scrollToEnd = true;
    }

    public void setCompletedListener(RemoteFileListener remoteFileListener) {
        this._remoteFileListener = remoteFileListener;
    }

    public void displayRemoteFile(final JniorInfo jniorInfo, final String remoteFileName) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FTPClient ftpClient = null;
                try {
                    ftpClient = new FTPClient();
                    ftpClient.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out)));
                    ftpClient.connect(jniorInfo.IpAddress, 21);
                    int reply = ftpClient.getReplyCode();
                    if (!FTPReply.isPositiveCompletion(reply)) {
                        ftpClient.disconnect();
                        throw new IOException("Exception in connecting to FTP Server");
                    }
                    if (ftpClient.login(jniorInfo.UserName, jniorInfo.Password)) {
                        String tempFile = String.format("%s/%s_%s_%s", SupporterMain.getTempDirectory(), jniorInfo.getSerialNumber(), FOLDER_DATE_FORMAT.format(new Date()), remoteFileName);
                        FileOutputStream out = new FileOutputStream(tempFile);
                        boolean result = ftpClient.retrieveFile(remoteFileName, out);
                        if (result) {
                            String fileContents = FileUtils.readAllText(tempFile);
                            RemoteFileTextDialog.this.appendText(String.format("\n-- %s --\n%s", remoteFileName, fileContents));
                            if (RemoteFileTextDialog.this._scrollToEnd) {
                                RemoteFileTextDialog.this.setCaretPosition(-1);
                            }
                        }
                        RemoteFileTextDialog.this._remoteFileListener.fileReceived(jniorInfo, remoteFileName);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(BeaconTab.class.getName()).severe(ex.getMessage());
                }
                finally {
                    if (null != ftpClient) {
                        try {
                            ftpClient.disconnect();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(BeaconTab.class.getName()).severe(ex.getMessage());
                        }
                    }
                }
            }
        }).start();
    }
}

