/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.JniorControlConnection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.beacon.BeaconPopupMenu;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Logger;

public class DoGetNetworkCapture {
    private final JniorInfo _jniorInfo;

    public DoGetNetworkCapture(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
    }

    public void execute() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JniorControlConnection jniorControlConnection = JniorControlConnection.getFor(DoGetNetworkCapture.this._jniorInfo, Logger.getGlobal());
                try {
                    jniorControlConnection.exec("netstat -c");
                    File networkCapturesTempDirectory = new File(SupporterMain.TEMP_DIRECTORY + File.separator + "Network Captures");
                    if (!networkCapturesTempDirectory.exists()) {
                        networkCapturesTempDirectory.mkdir();
                    }
                    String networkFilename = String.format("network_%s.pcapng", ((DoGetNetworkCapture)DoGetNetworkCapture.this)._jniorInfo.Hostname);
                    File tempNetworkFile = new File(networkCapturesTempDirectory.getPath() + File.separator + networkFilename);
                    FileOutputStream out = new FileOutputStream(tempNetworkFile.getPath());
                    jniorControlConnection.retrieveFile("/temp/network.pcapng", out);
                    boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
                    if (isWindows) {
                        Runtime.getRuntime().exec("explorer.exe /select," + tempNetworkFile.getPath());
                    } else {
                        Desktop desktop = Desktop.getDesktop();
                        desktop.open(networkCapturesTempDirectory);
                    }
                    ((DoGetNetworkCapture)DoGetNetworkCapture.this)._jniorInfo.AttentionInfo = (short)(((DoGetNetworkCapture)DoGetNetworkCapture.this)._jniorInfo.AttentionInfo & 0xEF0);
                }
                catch (Exception ex) {
                    String stacktrace = ExceptionUtils.getStackTrace(ex);
                    Logger.getLogger(BeaconPopupMenu.class.getName()).severe(stacktrace);
                }
            }
        }).start();
    }
}

