/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.net.LoginFailedException;
import com.integ.supporter.JniorControlConnection;
import com.integ.websocket.ConsoleSession;
import com.integ.websocket.WebSocketClient;
import com.integ.websocket.WebSocketClientAuthenticationAdapter;
import com.integ.websocket.WebSocketClientAuthenticationEvent;
import com.integ.websocket.helpers.DownloadFile;
import com.integ.websocket.helpers.FileProgressErrorEvent;
import com.integ.websocket.helpers.FileProgressListener;
import com.integ.websocket.helpers.FileProgressUpdatedEvent;
import com.integ.websocket.helpers.GetFileListing;
import com.integ.websocket.helpers.UploadFile;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPFile;

public class JniorSeries4ControlConnection
extends JniorControlConnection {
    private WebSocketClient _websocketClient = null;

    protected JniorSeries4ControlConnection(JniorInfo targetJniorInfo, Logger logger) {
        super(targetJniorInfo, logger);
        System.out.println("_websocketClient = " + this._websocketClient);
    }

    @Override
    protected boolean init() {
        return this.initWebSocketClient();
    }

    @Override
    public boolean isCommandConnectionConnected() {
        return this._websocketClient.isConnected();
    }

    @Override
    public boolean connect() {
        return this.initWebSocketClient();
    }

    private boolean initWebSocketClient() {
        this._logger.info("Use Websockets");
        this._websocketClient = new WebSocketClient(this._targetJniorInfo.IpAddress, 80);
        this._websocketClient.setCredentials(this._targetJniorInfo.UserName, this._targetJniorInfo.Password);
        this._websocketClient.addAuthenticationListener(new WebSocketClientAuthenticationAdapter(){

            @Override
            public void onAuthenticationFailed(WebSocketClientAuthenticationEvent event) {
                JniorSeries4ControlConnection.this._logger.info("Websocket authentication failed!");
            }
        });
        boolean connected = this._websocketClient.openAndWait();
        if (connected && this._websocketClient.isLoggedIn()) {
            ConsoleSession consoleSession = this._websocketClient.getConsoleSession();
            consoleSession.setLogger(this._logger);
            System.out.println("_websocketClient = " + this._websocketClient);
            return true;
        }
        return false;
    }

    @Override
    public void disconnect() throws IOException {
        if (null != this._websocketClient) {
            this._websocketClient.disconnect();
            if (this._websocketClient.isConnected()) {
                this._logger.severe("  websocket client did not disconnect");
            } else {
                this._logger.info("  websocket client disconnected");
            }
        }
    }

    @Override
    public boolean storeFile(String _remotePath, InputStream inputStream) throws IOException {
        UploadFile uploadFile = new UploadFile(this._websocketClient, inputStream, _remotePath);
        uploadFile.addFileProgressListener(new FileProgressListener(){

            @Override
            public void fileProgressUpdated(FileProgressUpdatedEvent fileProgressUpdatedEvent) {
                JniorSeries4ControlConnection.this._logger.info(String.format("    ---> %s: %d%%", fileProgressUpdatedEvent.getRemotePath(), fileProgressUpdatedEvent.getPercent()));
            }

            @Override
            public void fileProgressError(FileProgressErrorEvent fileProgressErrorEvent) {
                JniorSeries4ControlConnection.this._logger.severe(fileProgressErrorEvent.getError());
            }
        });
        return uploadFile.putContents();
    }

    @Override
    public boolean login(String userName, String password) throws LoginFailedException {
        return true;
    }

    @Override
    public FTPFile[] listFiles(String directory) throws IOException {
        GetFileListing fileListing = new GetFileListing(this._websocketClient, directory);
        ArrayList<FTPFile> ftpFiles = fileListing.getFiles();
        return ftpFiles.toArray(new FTPFile[0]);
    }

    @Override
    public void send(String string) throws Exception {
        this._websocketClient.getConsoleSession().send(string);
    }

    @Override
    public String exec(String command) throws Exception {
        return this.exec(command, 120000);
    }

    @Override
    public String exec(String command, int timeout) throws Exception {
        return this._websocketClient.getConsoleSession().exec(command);
    }

    @Override
    public boolean retrieveFile(String remotePath, FileOutputStream fileOutputStream) throws IOException {
        try {
            DownloadFile downloadFile = new DownloadFile(this._websocketClient, remotePath);
            downloadFile.addFileProgressListener(new FileProgressListener(){

                @Override
                public void fileProgressUpdated(FileProgressUpdatedEvent fileProgressUpdatedEvent) {
                    JniorSeries4ControlConnection.this._logger.info(String.format("    <--- %s: %d%%", fileProgressUpdatedEvent.getRemotePath(), fileProgressUpdatedEvent.getPercent()));
                }

                @Override
                public void fileProgressError(FileProgressErrorEvent fileProgressErrorEvent) {
                    JniorSeries4ControlConnection.this._logger.severe(fileProgressErrorEvent.getError());
                }
            });
            byte[] fileContentBytes = downloadFile.getContents();
            fileOutputStream.write(fileContentBytes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        return true;
    }
}

