/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.net.LoginFailedException;
import com.integ.supporter.JniorSeries3ControlConnection;
import com.integ.supporter.JniorSeries4ControlConnection;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPFile;

public abstract class JniorControlConnection {
    protected final JniorInfo _targetJniorInfo;
    protected final Logger _logger;

    public static JniorControlConnection getFor(JniorInfo targetJniorInfo, Logger logger) {
        JniorControlConnection jniorControlConnection = null;
        if (3 == targetJniorInfo.getSeries()) {
            jniorControlConnection = new JniorSeries3ControlConnection(targetJniorInfo, logger);
        } else if (4 == targetJniorInfo.getSeries()) {
            jniorControlConnection = new JniorSeries4ControlConnection(targetJniorInfo, logger);
        }
        if (null == jniorControlConnection) {
            throw new RuntimeException("Jnior Update Control Connection Not Initiated");
        }
        ((JniorControlConnection)jniorControlConnection).init();
        return jniorControlConnection;
    }

    protected JniorControlConnection(JniorInfo targetJniorInfo, Logger logger) {
        this._targetJniorInfo = targetJniorInfo;
        this._logger = logger;
    }

    protected abstract boolean init();

    public abstract boolean isCommandConnectionConnected();

    public abstract boolean connect();

    public abstract void disconnect() throws IOException;

    public abstract boolean storeFile(String var1, InputStream var2) throws IOException;

    public abstract void send(String var1) throws Exception;

    public abstract String exec(String var1) throws Exception;

    public abstract String exec(String var1, int var2) throws Exception;

    public abstract boolean retrieveFile(String var1, FileOutputStream var2) throws IOException;

    public abstract boolean login(String var1, String var2) throws LoginFailedException;

    public abstract FTPFile[] listFiles(String var1) throws IOException;
}

