/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net;

import com.integ.janoslib.net.BytesReceivedEvent;
import com.integ.janoslib.net.LoginFailedException;
import com.integ.janoslib.net.TcpConnection;
import com.integ.janoslib.net.TcpConnectionListener;
import com.integ.janoslib.net.TelnetClientAuthenticationFailedEvent;
import com.integ.janoslib.net.TelnetClientAuthenticationListener;
import com.integ.janoslib.net.TelnetClientAuthenticationSuccessEvent;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.RollingLog;
import java.util.EventObject;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TelnetClient
implements TcpConnectionListener {
    private static final Logger LOGGER = RollingLog.getLogger("TelnetClient");
    private static final int PORT = 23;
    private static final Pattern PROMPT_PATTERN = Pattern.compile("[\\r?\\n]*([\\w-]*) (\\/\\w*)+> ");
    private TelnetClientAuthenticationListener _authenticationListener;
    private final TcpConnection _tcpConnection = new TcpConnection();
    private final StringBuilder _response = new StringBuilder();
    private final Object WAITING_FOR_USERNAME_LOCK = new Object();
    private final Object WAITING_FOR_PASSWORD_LOCK = new Object();
    private final Object WAITING_FOR_PROMPT_LOCK = new Object();
    private final Object WAITING_FOR_NEW_CREDENTIALS_LOCK = new Object();
    private String _hostAddressString;
    private boolean _isOpen;
    private boolean _isLoggedIn;
    private boolean _loginFailed;
    private boolean _waitingForUsername;
    private boolean _waitingForPassword;
    private String _hostname;
    private String _username = "jnior";
    private String _password = "jnior";

    public TelnetClient(String hostAddressString) {
        this._hostAddressString = hostAddressString;
    }

    public String getHostAddress() {
        return this._hostAddressString;
    }

    public String getHostname() {
        return this._hostname;
    }

    public boolean isConnected() {
        return this._isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(String userName, String password) {
        Object object = this.WAITING_FOR_NEW_CREDENTIALS_LOCK;
        synchronized (object) {
            System.out.println("set credentials");
            this._username = userName;
            this._password = password;
            this.WAITING_FOR_NEW_CREDENTIALS_LOCK.notifyAll();
            System.out.println("new credentials supplied");
        }
    }

    public TelnetClient setAuthenticationListener(TelnetClientAuthenticationListener listener) {
        this._authenticationListener = listener;
        return this;
    }

    public String getConnectionInfo() {
        return this._tcpConnection.getConnectionInfo();
    }

    public boolean connect(String hostAddressString) throws Exception {
        this._hostAddressString = hostAddressString;
        this._tcpConnection.setHostInformation(hostAddressString, 23);
        this._tcpConnection.addConnectionListener(this);
        return this._tcpConnection.connect();
    }

    public void disconnect() {
        this._isOpen = false;
        this._isLoggedIn = false;
        this._waitingForUsername = false;
        this._waitingForPassword = false;
        this._tcpConnection.close(true);
    }

    @Override
    public void connectionAttempt(EventObject evt) {
        TcpConnection tcpConnection = (TcpConnection)evt.getSource();
        String clientInfo = tcpConnection.getConnectionInfo();
        System.out.println(clientInfo + " telnet attempt");
    }

    @Override
    public void connectionEstablished(EventObject evt) {
        TcpConnection tcpConnection = (TcpConnection)evt.getSource();
        String clientInfo = tcpConnection.getConnectionInfo();
        System.out.println(clientInfo + " telnet connected");
        this._isOpen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(EventObject evt) {
        TcpConnection tcpConnection = (TcpConnection)evt.getSource();
        String clientInfo = tcpConnection.getConnectionInfo();
        System.out.println(clientInfo + " telnet closed");
        Object object = this.WAITING_FOR_PROMPT_LOCK;
        synchronized (object) {
            this.WAITING_FOR_PROMPT_LOCK.notifyAll();
        }
        this._isOpen = false;
        this._isLoggedIn = false;
        this._waitingForUsername = false;
        this._waitingForPassword = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bytesReceived(BytesReceivedEvent evt) {
        TcpConnection tcpConnection = (TcpConnection)evt.getSource();
        String clientInfo = tcpConnection.getConnectionInfo();
        String message = new String(evt.getBytes(), evt.getOffset(), evt.getLength());
        System.out.println(clientInfo + " received " + message);
        if (!this._waitingForUsername && message.contains("login:")) {
            Object object = this.WAITING_FOR_USERNAME_LOCK;
            synchronized (object) {
                this._waitingForUsername = true;
                System.out.println(String.format("notify %s username lock", this.getConnectionInfo()));
                this.WAITING_FOR_USERNAME_LOCK.notifyAll();
            }
        }
        if (!this._waitingForPassword && message.contains("password:")) {
            Object object = this.WAITING_FOR_PASSWORD_LOCK;
            synchronized (object) {
                this._waitingForPassword = true;
                System.out.println(String.format("notify %s password lock", this.getConnectionInfo()));
                this.WAITING_FOR_PASSWORD_LOCK.notifyAll();
            }
        }
        if (message.contains("Login incorrect.")) {
            this._loginFailed = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TelnetClientAuthenticationFailedEvent authenticationFailedEvent = new TelnetClientAuthenticationFailedEvent(TelnetClient.this);
                    TelnetClient.this._authenticationListener.onAuthenticationFailed(authenticationFailedEvent);
                }
            }).start();
            Object object = this.WAITING_FOR_PROMPT_LOCK;
            synchronized (object) {
                System.out.println(String.format("notify %s prompt lock", this.getConnectionInfo()));
                this.WAITING_FOR_PROMPT_LOCK.notifyAll();
            }
        }
        this._response.append(message);
        System.out.println("prompt found in response: |" + this._response.toString() + "|");
        Matcher matcher = PROMPT_PATTERN.matcher(this._response.toString());
        if (matcher.find()) {
            if (!this._isLoggedIn) {
                this._loginFailed = false;
                this._isLoggedIn = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        TelnetClientAuthenticationSuccessEvent authenticationSuccessEvent = new TelnetClientAuthenticationSuccessEvent(TelnetClient.this);
                        TelnetClient.this._authenticationListener.onAuthenticationSuccess(authenticationSuccessEvent);
                    }
                }).start();
            }
            String _hostname = matcher.group(1);
            int start = matcher.start();
            this._response.setLength(start);
            Object object = this.WAITING_FOR_PROMPT_LOCK;
            synchronized (object) {
                System.out.println(String.format("notify %s prompt lock", this.getConnectionInfo()));
                this.WAITING_FOR_PROMPT_LOCK.notifyAll();
            }
        }
    }

    public boolean login() throws LoginFailedException {
        return this.login(this._username, this._password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String username, String password) throws LoginFailedException {
        this._username = username;
        this._password = password;
        try {
            if (!this._isLoggedIn) {
                Object object = this.WAITING_FOR_USERNAME_LOCK;
                synchronized (object) {
                    if (!this._waitingForUsername) {
                        System.out.println(String.format("wait for %s username lock", this.getConnectionInfo()));
                        this.WAITING_FOR_USERNAME_LOCK.wait(5000L);
                    }
                }
                if (!this._waitingForUsername) {
                    throw new RuntimeException("Did not receive login prompt");
                }
                this._response.setLength(0);
                this.send(username + "\n");
                object = this.WAITING_FOR_PASSWORD_LOCK;
                synchronized (object) {
                    if (!this._waitingForPassword) {
                        System.out.println(String.format("wait for %s password lock", this.getConnectionInfo()));
                        this.WAITING_FOR_PASSWORD_LOCK.wait(5000L);
                    }
                }
                if (!this._waitingForPassword) {
                    throw new RuntimeException("Did not receive password prompt");
                }
                this._response.setLength(0);
                this.send(password + "\n");
                object = this.WAITING_FOR_PROMPT_LOCK;
                synchronized (object) {
                    if (!this._isLoggedIn) {
                        System.out.println(String.format("wait for %s prompt lock", this.getConnectionInfo()));
                        this.WAITING_FOR_PROMPT_LOCK.wait(5000L);
                    }
                }
                if (this._loginFailed) {
                    this._waitingForUsername = false;
                    this._waitingForPassword = false;
                    if (null == this._authenticationListener) {
                        throw new LoginFailedException("Login Failed");
                    }
                    object = this.WAITING_FOR_NEW_CREDENTIALS_LOCK;
                    synchronized (object) {
                        System.out.println(String.format("wait for new credentials  ", this.getConnectionInfo()));
                        this.WAITING_FOR_NEW_CREDENTIALS_LOCK.wait(60000L);
                        System.out.println(String.format("new credentials supplied", this.getConnectionInfo()));
                    }
                    return false;
                }
                if (!this._isLoggedIn) {
                    throw new RuntimeException("Did not receive prompt");
                }
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.severe(ExceptionUtils.getStackTrace(ex));
            throw new LoginFailedException("failed to log in to " + this._hostAddressString);
        }
    }

    public void send(String text) throws Exception {
        if (!this._isOpen && this.connect(this._hostAddressString) && !this.login()) {
            System.out.println("retry the login");
            this.login();
        }
        System.out.println(this._tcpConnection.getConnectionInfo() + " send: " + text);
        this._tcpConnection.send(text.getBytes());
    }

    public String exec(String command) throws Exception {
        return this.exec(command, 120000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exec(String command, int timeout) throws Exception {
        this.send(String.format("%s\r\n", command));
        Object object = this.WAITING_FOR_PROMPT_LOCK;
        synchronized (object) {
            this._response.setLength(0);
            try {
                long timeoutExpire = System.currentTimeMillis() + (long)timeout;
                this.WAITING_FOR_PROMPT_LOCK.wait(timeout);
                if (System.currentTimeMillis() >= timeoutExpire) {
                    throw new RuntimeException(command + " command timed out");
                }
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(command + " command was interrupted", ex);
            }
            String response = this._response.toString();
            if (response.contains(command)) {
                response = response.substring(command.length());
            }
            return response;
        }
    }
}

