/*
 * Decompiled with CFR 0.152.
 */
package com.integ.beacon;

import com.integ.beacon.Version;
import com.integ.janoslib.utils.ExceptionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class JniorInfo {
    private static final Object GET_INFO_LOCK = new Object();
    public static final int ALIVE = 0;
    public static final int REBOOT_REQUESTED = 1;
    public static final int REBOOTING = 2;
    public static final int GETTING_NETWORK_CAPTURE = 256;
    private String PublicHostAddress;
    public int BeaconPort = 4444;
    private int SerialNumber;
    public String Model;
    public String Hostname;
    public String IpAddress;
    public String SubnetMask;
    public String PhysicalAddress;
    public boolean AutoAnnounce;
    public Version OsVersion;
    public int ProtocolPort;
    public Date BootTime;
    public Date LastAnnounced;
    public short AttentionInfo;
    public Date CurrentTime;
    public String Gateway;
    public String PrimaryDns;
    public String SecondaryDns;
    public int DnsTimeout;
    public String DhcpServer;
    public String DomainName;
    public String Timezone;
    public boolean DhcpEnabled;
    public String UserName = "jnior";
    public String Password = "jnior";
    public String Nonce;
    public int Status = 0;
    public boolean AccessibleFromLocalMachine;

    private JniorInfo() {
    }

    public JniorInfo(int serialNumber) {
        this.setSerialNumber(serialNumber);
    }

    public JniorInfo setSerialNumber(int serialNumber) {
        this.SerialNumber = serialNumber;
        int model = this.SerialNumber / 100000000;
        switch (model) {
            case 1: 
            case 2: {
                this.Model = "310";
                break;
            }
            case 3: {
                this.Model = "312";
                break;
            }
            case 4: {
                this.Model = "314";
                break;
            }
            case 6: {
                this.Model = "410";
                break;
            }
            case 7: {
                this.Model = "412";
                break;
            }
            case 8: {
                this.Model = "414";
                break;
            }
            case 9: {
                this.Model = "412DMX";
            }
        }
        return this;
    }

    public int getSerialNumber() {
        return this.SerialNumber;
    }

    public String getPublicHostAddress() {
        return null != this.PublicHostAddress ? this.PublicHostAddress : this.IpAddress;
    }

    public JniorInfo setPublicHostAddress(String hostAddress) {
        this.PublicHostAddress = hostAddress;
        return this;
    }

    public JniorInfo clone() {
        JniorInfo jniorInfoClone = new JniorInfo();
        jniorInfoClone.SerialNumber = this.SerialNumber;
        jniorInfoClone.Model = this.Model;
        jniorInfoClone.Hostname = this.Hostname;
        jniorInfoClone.IpAddress = this.IpAddress;
        jniorInfoClone.SubnetMask = this.SubnetMask;
        jniorInfoClone.PhysicalAddress = this.PhysicalAddress;
        jniorInfoClone.AutoAnnounce = this.AutoAnnounce;
        jniorInfoClone.OsVersion = this.OsVersion;
        jniorInfoClone.ProtocolPort = this.ProtocolPort;
        jniorInfoClone.BootTime = this.BootTime;
        jniorInfoClone.LastAnnounced = this.LastAnnounced;
        jniorInfoClone.AttentionInfo = this.AttentionInfo;
        jniorInfoClone.Gateway = this.Gateway;
        jniorInfoClone.PrimaryDns = this.PrimaryDns;
        jniorInfoClone.SecondaryDns = this.SecondaryDns;
        jniorInfoClone.DnsTimeout = this.DnsTimeout;
        jniorInfoClone.DhcpServer = this.DhcpServer;
        jniorInfoClone.DomainName = this.DomainName;
        jniorInfoClone.Timezone = this.Timezone;
        jniorInfoClone.DhcpEnabled = this.DhcpEnabled;
        jniorInfoClone.UserName = this.UserName;
        jniorInfoClone.Password = this.Password;
        jniorInfoClone.Nonce = this.Nonce;
        return jniorInfoClone;
    }

    public boolean equals(JniorInfo jniorInfo) {
        boolean equals = true;
        equals = false;
        return equals;
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        for (Field field : this.getClass().getFields()) {
            try {
                Object value;
                if (Modifier.isFinal(field.getModifiers()) || (value = field.get(this)) == null) continue;
                jsonObject.put(field.getName(), value);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(JniorInfo.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(JniorInfo.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        }
        return jsonObject;
    }

    public static JniorInfo fromJSON(JSONObject jsonObject) {
        JniorInfo jniorInfo = new JniorInfo();
        for (Field field : jniorInfo.getClass().getFields()) {
            try {
                Object value;
                String fieldName = field.getName();
                if (!jsonObject.has(fieldName) || (value = jsonObject.get(fieldName)) == null) continue;
                if (field.getType().isAssignableFrom(Date.class) || field.getType().isAssignableFrom(Version.class)) {
                    // empty if block
                }
                field.set(jniorInfo, value);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                Logger.getLogger(JniorInfo.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                Logger.getLogger(JniorInfo.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.getLogger(JniorInfo.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        }
        return jniorInfo;
    }

    public String toString() {
        return this.SerialNumber + " | " + this.IpAddress + " | " + this.Hostname;
    }

    public int getSeries() {
        if (500000000 > this.SerialNumber) {
            return 3;
        }
        if (600000000 < this.SerialNumber) {
            return 4;
        }
        throw new RuntimeException("Invalid Serial Number: " + this.SerialNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInfo() {
        Object object = GET_INFO_LOCK;
        synchronized (object) {
            try {
                GET_INFO_LOCK.wait(5000L);
            }
            catch (InterruptedException ex) {
                Logger.getGlobal().log(Level.SEVERE, ExceptionUtils.getStackTrace(ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInfo() {
        Object object = GET_INFO_LOCK;
        synchronized (object) {
            GET_INFO_LOCK.notifyAll();
        }
    }
}

