/*
 * Decompiled with CFR 0.152.
 */
package com.integ.websocket.helpers;

import com.integ.websocket.WebSocketClient;
import com.integ.websocket.WebSocketClientMessageListener;
import com.integ.websocket.WebSocketClientMessageReceivedEvent;
import com.integ.websocket.helpers.FileProgressErrorEvent;
import com.integ.websocket.helpers.FileProgressListener;
import com.integ.websocket.helpers.FileProgressNotifier;
import com.integ.websocket.helpers.FileProgressUpdatedEvent;
import com.integ.websocket.messages.FileWrite;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.json.JSONObject;

public class UploadFile
implements WebSocketClientMessageListener {
    private static final HashMap<String, Object> FILE_RECEIVE_WAIT_OBJECT = new HashMap();
    private final int LIMIT = 131072;
    private final WebSocketClient _websocketClient;
    private final InputStream _inputStream;
    private String _remotePath;
    private int _offset = 0;
    private FileWrite _fileWrite;
    private boolean _success;
    private final FileProgressNotifier _fileProgressNotifier = new FileProgressNotifier();

    public UploadFile(WebSocketClient websocketClient, File localFile, String remotePath) throws FileNotFoundException {
        this(websocketClient, new FileInputStream(localFile), remotePath);
    }

    public UploadFile(WebSocketClient websocketClient, InputStream inputStream, String remotePath) {
        websocketClient.addMessageListener(this);
        this._websocketClient = websocketClient;
        this._inputStream = inputStream;
        this._remotePath = remotePath;
    }

    public void addFileProgressListener(FileProgressListener fileProgressListener) {
        this._fileProgressNotifier.addEventListener(fileProgressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(WebSocketClientMessageReceivedEvent event) {
        block12: {
            WebSocketClient websocketClient = event.getClient();
            JSONObject jsonMessage = event.getJsonMessage();
            String message = jsonMessage.getString("Message");
            if ("File Write Response".equals(message)) {
                String status = jsonMessage.getString("Status");
                JSONObject meta = jsonMessage.getJSONObject("Meta");
                String hash = meta.getString("Hash");
                if (!"Fail".equalsIgnoreCase(status)) {
                    try {
                        Object thisFileWaitObject;
                        if (!this._fileWrite.getHash().equals(hash)) break block12;
                        int fileSize = jsonMessage.getInt("Size");
                        this._success = true;
                        Object object = thisFileWaitObject = FILE_RECEIVE_WAIT_OBJECT.get(hash);
                        synchronized (object) {
                            thisFileWaitObject.notifyAll();
                        }
                    }
                    catch (Exception ex) {
                        this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remotePath, ex.getMessage()));
                    }
                } else {
                    this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remotePath, String.format("File Upload Failed: %s", jsonMessage.toString())));
                    Object thisFileWaitObject = FILE_RECEIVE_WAIT_OBJECT.get(hash);
                    if (null != thisFileWaitObject) {
                        Object object = thisFileWaitObject;
                        synchronized (object) {
                            thisFileWaitObject.notifyAll();
                        }
                    }
                }
            }
        }
    }

    public void finalize() {
        try {
            super.finalize();
            this._websocketClient.removeMessageListener(this);
        }
        catch (Throwable ex) {
            this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remotePath, ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putContents() throws IOException {
        int pos = 0;
        byte[] buffer = new byte[16384];
        int byteReadCount = 0;
        while (0 < (byteReadCount = this._inputStream.read(buffer))) {
            this._fileWrite = new FileWrite(this._remotePath, buffer, byteReadCount);
            if (0 < pos) {
                this._fileWrite.put("Append", true);
            }
            this._websocketClient.send(this._fileWrite);
            double fileSize = (pos += byteReadCount) + this._inputStream.available();
            int percent = (int)((double)(pos * 100) / fileSize);
            this._fileProgressNotifier.notifyFileProgressUpdated(new FileProgressUpdatedEvent(this, this._remotePath, percent));
            Object thisFileWaitObject = new Object();
            FILE_RECEIVE_WAIT_OBJECT.put(this._fileWrite.getHash(), thisFileWaitObject);
            try {
                Object object = thisFileWaitObject;
                synchronized (object) {
                    thisFileWaitObject.wait(120000L);
                }
            }
            catch (InterruptedException ex) {
                this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remotePath, ex.getMessage()));
            }
        }
        return this._success;
    }
}

