/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.supporter.updater.steps.FtpStep;
import java.io.IOException;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class UpdateSeries3OSStep
extends FtpStep {
    protected final String _version = this.getChildNodeString("Version");

    public UpdateSeries3OSStep(Element xmlElement) {
        super(xmlElement);
        System.out.println("Version: " + this._version);
    }

    @Override
    public boolean execute() throws Exception {
        if (3 != this._jniorInfo.getSeries()) {
            throw new RuntimeException("The target JNIOR is not a series 3 jnior");
        }
        String versionResponse = this._jniorUpdateControlConnection.exec("registry $Version");
        int equalPos = versionResponse.indexOf("=");
        if (-1 != equalPos) {
            versionResponse = versionResponse.substring(equalPos + 1);
            versionResponse = versionResponse.trim();
            this._logger.info(String.format("  remote version: %s", versionResponse));
            if (versionResponse.equalsIgnoreCase(this._version)) {
                this._logger.info("  JNIOR " + this._version + " already installed");
                return true;
            }
        }
        super.execute();
        String rebootCommand = "reboot\ny";
        this._logger.info("  rebooting...");
        this._jniorUpdateControlConnection.exec(rebootCommand);
        this._logger.info("  wait for the telnet connection to disconnect");
        long connectionDisconnectTimeout = System.currentTimeMillis() + 60000L;
        while (this._jniorUpdateControlConnection.isCommandConnectionConnected()) {
            Thread.sleep(1000L);
            if (connectionDisconnectTimeout >= System.currentTimeMillis()) continue;
            this._logger.warning("  telnet client disconnection timeout");
            break;
        }
        try {
            this._jniorUpdateControlConnection.disconnect();
        }
        catch (IOException ex) {
            Logger.getLogger(UpdateSeries3OSStep.class.getName()).severe(ex.getMessage());
        }
        long rebootTimeout = System.currentTimeMillis() + 300000L;
        while (System.currentTimeMillis() < rebootTimeout) {
            Thread.sleep(30000L);
            if (!this._jniorUpdateControlConnection.connect()) continue;
            break;
        }
        return true;
    }
}

