/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.beacon.Beacon;
import com.integ.beacon.BeaconListener;
import com.integ.beacon.JniorInfo;
import com.integ.beacon.commands.GetInfoCommand;
import com.integ.beacon.commands.IdentifyCommand;
import com.integ.beacon.commands.QueryAllCommand;
import com.integ.beacon.commands.SetDhcpCommand;
import com.integ.beacon.commands.SetInfoCommand;
import com.integ.janoslib.utils.StringUtils;
import com.integ.supporter.ApplicationConfig;
import com.integ.supporter.JniorAnnouncementStore;
import com.integ.supporter.JniorItem;
import com.integ.supporter.beacon.BeaconPopupMenu;
import com.integ.supporter.beacon.BeaconTableModel;
import com.integ.supporter.beacon.BeaconTableRenderer;
import com.integ.supporter.beacon.ColumnTableSorter;
import com.integ.supporter.beacon.DateStringComparator;
import com.integ.supporter.beacon.IpAddressComparator;
import com.integ.supporter.beacon.RemoteFileListener;
import com.integ.supporter.dialogs.LoginDialog2;
import com.integ.supporter.ui.RemoteFileTextDialog;
import com.integ.supporter.ui.StatusBar;
import com.integ.supporter.ui.TableHeaderRenderer;
import com.integ.supporter.ui.jtable.ColumnWidthPersistance;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.json.JSONObject;

public class BeaconTab
extends JPanel
implements BeaconListener,
TableModelListener,
RemoteFileListener {
    private final BeaconTableModel _tableModel = new BeaconTableModel();
    private final JTable _table = new JTable(this._tableModel);
    private final ColumnTableSorter _sorter;
    private BeaconPopupMenu _popupMenu;
    private String _beaconStatus = "";
    private ArrayList<String> _pendingRemoteFiles;
    private RemoteFileTextDialog _textDialog;
    private JniorInfo _jniorInfo;

    public BeaconTab() {
        Beacon.getInstance().addBeaconListener(this);
        this.setLayout(new GridLayout(1, 1));
        this._table.setDoubleBuffered(true);
        this._table.setSelectionMode(2);
        this._table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this._table.setFillsViewportHeight(true);
        AbstractAction queryAll = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeaconTab.this.queryAll();
            }
        };
        this._table.getInputMap().put(KeyStroke.getKeyStroke("F5"), "queryAll");
        this._table.getActionMap().put("queryAll", queryAll);
        JTableHeader header = this._table.getTableHeader();
        header.setDefaultRenderer(new TableHeaderRenderer(this._table));
        BeaconTableRenderer beaconTableRenderer = new BeaconTableRenderer();
        this._table.setDefaultRenderer(Object.class, beaconTableRenderer);
        this._table.setRowHeight(20);
        this._table.setShowVerticalLines(false);
        this._table.setShowHorizontalLines(false);
        TableColumnModel columnModel = this._table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            int width = this._tableModel.getColumnWidth(i);
            columnModel.getColumn(i).setPreferredWidth(width);
        }
        this._table.setAutoResizeMode(0);
        ColumnWidthPersistance columnWidthPersistance = new ColumnWidthPersistance("BeaconColumnWidths", this._table);
        this._sorter = new ColumnTableSorter(this._table.getModel());
        this._sorter.addTableColumnComparator(3, new IpAddressComparator());
        this._sorter.addTableColumnComparator(7, new DateStringComparator());
        this._sorter.addTableColumnComparator(8, new DateStringComparator());
        this._table.setRowSorter(this._sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(3, SortOrder.ASCENDING));
        this._sorter.setSortKeys(sortKeys);
        JScrollPane scrollPane = new JScrollPane(this._table);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add(scrollPane);
        this.createPopupMenu();
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                System.out.println(String.format("%s mouse released", this.getClass().getName()));
                int r = BeaconTab.this._table.rowAtPoint(e.getPoint());
                if (r >= 0 && r < BeaconTab.this._table.getRowCount()) {
                    if (1 >= BeaconTab.this.getSelectedRowCount()) {
                        BeaconTab.this._table.setRowSelectionInterval(r, r);
                    }
                } else {
                    BeaconTab.this._table.clearSelection();
                }
                if (e.isPopupTrigger() || e.isMetaDown()) {
                    System.out.println(String.format("%s show popup", this.getClass().getName()));
                    BeaconTab.this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JniorAnnouncementStore.init();
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(50L);
                            BeaconTab.this._table.repaint();
                        }
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(BeaconTab.class.getName()).severe(ex.getMessage());
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public void resizeTableColumns() {
        TableColumnModel columnModel = this._table.getColumnModel();
        int[] columnWidths = new int[this._table.getColumnCount()];
        for (int column = 0; column < this._table.getColumnCount(); ++column) {
            int width = 15;
            for (int row = 0; row < this._table.getRowCount(); ++row) {
                TableCellRenderer renderer = this._table.getCellRenderer(row, column);
                Component comp = this._table.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width + 1, width);
            }
            columnWidths[column] = width += 12;
            columnModel.getColumn(column).setPreferredWidth(width);
        }
        ApplicationConfig.setBeaconColumnWidths(columnWidths);
    }

    public int selectedJniorCount() {
        return this._table.getSelectedRowCount();
    }

    @Override
    public void fileReceived(JniorInfo jniorInfo, String remoteFileName) {
        this.getNextRemoteFile();
    }

    private void createPopupMenu() {
        System.out.println(String.format("%s create popup menu", this.getClass().getName()));
        this._popupMenu = new BeaconPopupMenu(this);
    }

    public void retrieveAndDisplayRemoteFile(JniorInfo jniorInfo, String remoteFileName, boolean scrollToEnd) throws UnknownHostException, IOException {
        this.retrieveAndDisplayRemoteFiles(jniorInfo, new String[]{remoteFileName}, scrollToEnd);
    }

    public void retrieveAndDisplayRemoteFiles(JniorInfo jniorInfo, String[] remoteFileNames, boolean scrollToEnd) throws UnknownHostException, IOException {
        this._pendingRemoteFiles = new ArrayList<String>(Arrays.asList(remoteFileNames));
        String remoteFileNamesString = StringUtils.join(remoteFileNames, ", ");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this._table);
        this._jniorInfo = jniorInfo;
        this._textDialog = new RemoteFileTextDialog(topFrame, true);
        this._textDialog.setTitle(String.format("%s /%s", jniorInfo.IpAddress, remoteFileNamesString));
        this._textDialog.setText(String.format("Retrieving %s\n", remoteFileNamesString));
        this._textDialog.setEditable(false);
        this._textDialog.setSize(1024, screenSize.height - 128);
        this._textDialog.setCompletedListener(this);
        if (scrollToEnd) {
            this._textDialog.setScrollToEnd();
        }
        this.getNextRemoteFile();
        this._textDialog.setVisible(true);
    }

    private void getNextRemoteFile() {
        if (0 < this._pendingRemoteFiles.size()) {
            String nextFile = this._pendingRemoteFiles.remove(0);
            this._textDialog.displayRemoteFile(this._jniorInfo, nextFile);
        }
    }

    public boolean removeRemoteFile(JniorInfo jniorInfo, String remoteFileName) throws UnknownHostException, IOException {
        return this.removeRemoteFiles(jniorInfo, new String[]{remoteFileName});
    }

    public boolean removeRemoteFiles(JniorInfo jniorInfo, String[] remoteFileNames) throws UnknownHostException, IOException {
        FTPClient _ftpClient = new FTPClient();
        _ftpClient.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out)));
        _ftpClient.connect(jniorInfo.IpAddress, 21);
        int reply = _ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            _ftpClient.disconnect();
            throw new IOException("Exception in connecting to FTP Server");
        }
        if (_ftpClient.login(jniorInfo.UserName, jniorInfo.Password)) {
            try {
                for (String remoteFileName : remoteFileNames) {
                    _ftpClient.deleteFile(remoteFileName);
                }
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public int getSelectedRowCount() {
        return this._table.getSelectedRowCount();
    }

    public ArrayList<JniorItem> getSelectedJniorItems() {
        int[] selectedRows;
        ArrayList<JniorItem> selectedJniorItems = new ArrayList<JniorItem>();
        for (int selectedRow : selectedRows = this._table.getSelectedRows()) {
            System.out.println("selectedRow = " + selectedRow);
            int viewRow = this._table.convertRowIndexToView(selectedRow);
            System.out.println("viewRow = " + viewRow);
            int selectedSerialNumber = (Integer)this._table.getValueAt(selectedRow, 0);
            JniorItem jniorItem = this._tableModel.getJniorItemBySerialNumber(selectedSerialNumber);
            selectedJniorItems.add(jniorItem);
        }
        return selectedJniorItems;
    }

    public JniorItem getSelectedJniorItem() {
        int selectedRow = this._table.getSelectedRow();
        System.out.println("selectedRow = " + selectedRow);
        int viewRow = this._table.convertRowIndexToView(selectedRow);
        System.out.println("viewRow = " + viewRow);
        int selectedSerialNumber = (Integer)this._table.getValueAt(selectedRow, 0);
        JniorItem jniorItem = this._tableModel.getJniorItemBySerialNumber(selectedSerialNumber);
        return jniorItem;
    }

    public boolean getJniorInfoCredentials(JniorInfo jniorInfo) {
        if (null != jniorInfo.Nonce) {
            JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this._table);
            LoginDialog2 loginDialog = new LoginDialog2((Frame)topFrame, true);
            loginDialog.centerParent();
            loginDialog.setVisible(true);
            if (loginDialog.getResult() == 1) {
                jniorInfo.UserName = loginDialog.getUsername();
                jniorInfo.Password = loginDialog.getPassword();
                return true;
            }
        }
        return false;
    }

    public void queryAll() {
        this._tableModel.clear();
        Beacon.getInstance().broadcastCommand(new QueryAllCommand());
    }

    public void identify(JniorInfo jniorInfo) {
        System.out.println("selected jnior Serial " + jniorInfo.getSerialNumber());
        IdentifyCommand identify = new IdentifyCommand(jniorInfo.getSerialNumber());
        Beacon.getInstance().broadcastCommand(identify);
    }

    public void getInfo(final JniorInfo jniorInfo) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("selected jnior Serial " + jniorInfo.getSerialNumber());
                    GetInfoCommand getInfo = new GetInfoCommand(jniorInfo.getSerialNumber());
                    Beacon.getInstance().send(InetAddress.getByName(jniorInfo.getPublicHostAddress()), jniorInfo.BeaconPort, getInfo);
                }
                catch (IOException ex) {
                    Logger.getLogger(BeaconTab.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }).start();
        jniorInfo.waitForInfo();
    }

    public void setInfo(JniorInfo jniorInfo) {
        System.out.println("setting info for jnior Serial " + jniorInfo.getSerialNumber());
        SetInfoCommand setInfo = new SetInfoCommand(jniorInfo);
        Beacon.getInstance().broadcastCommand(setInfo);
    }

    public void setDhcp(JniorInfo jniorInfo) {
        System.out.println("setting dhcp for jnior Serial " + jniorInfo.getSerialNumber());
        SetDhcpCommand setDhcp = new SetDhcpCommand(jniorInfo);
        Beacon.getInstance().broadcastCommand(setDhcp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unitUpdated(JniorInfo jniorInfo) {
        JniorItem[] jniors;
        ArrayList<JniorItem> selectedJniorItems = new ArrayList<JniorItem>();
        BeaconTableModel beaconTableModel = this._tableModel;
        synchronized (beaconTableModel) {
            Object selectedRows;
            if (0 < this._tableModel.getRowCount()) {
                selectedRows = this._table.getSelectedRows();
                for (int selectedRow : selectedRows) {
                    int modelRow = this._table.convertRowIndexToModel(selectedRow);
                    JniorItem modelRowJniorItem = this._tableModel.getJniorAt(modelRow);
                    selectedJniorItems.add(modelRowJniorItem);
                }
            }
            this._tableModel.updateJniorInfo(jniorInfo);
            selectedRows = selectedJniorItems.iterator();
            while (selectedRows.hasNext()) {
                JniorItem selectedJniorItem = (JniorItem)selectedRows.next();
                int modelRow = this._tableModel.getRowForJniorItem(selectedJniorItem);
                int viewRow = this._table.convertRowIndexToView(modelRow);
                this._table.addRowSelectionInterval(viewRow, viewRow);
            }
        }
        int model310Count = 0;
        int model312Count = 0;
        int model314Count = 0;
        int model410Count = 0;
        int model412Count = 0;
        int model412DMXCount = 0;
        int model414Count = 0;
        for (JniorItem jnior : jniors = this._tableModel.getJniors()) {
            if (jnior.getSerialNumber() < 300000000) {
                ++model310Count;
                continue;
            }
            if (jnior.getSerialNumber() < 400000000) {
                ++model312Count;
                continue;
            }
            if (jnior.getSerialNumber() < 500000000) {
                ++model314Count;
                continue;
            }
            if (jnior.getSerialNumber() < 700000000) {
                ++model410Count;
                continue;
            }
            if (jnior.getSerialNumber() < 800000000) {
                ++model412Count;
                continue;
            }
            if (jnior.getSerialNumber() < 900000000) {
                ++model414Count;
                continue;
            }
            if (jnior.getSerialNumber() < 900000000) continue;
            ++model412DMXCount;
        }
        this._beaconStatus = String.format("%d JNIORs (410: %d, 412: %d, 412DMX: %d, 414: %d, 310: %d, 312: %d, 314: %d)", this._tableModel.getRowCount(), model410Count, model412Count, model412DMXCount, model414Count, model310Count, model312Count, model314Count);
        StatusBar.setStatusText(this._beaconStatus);
        JniorAnnouncementStore.setAnnouncementJsonObject(jniorInfo.getSerialNumber(), jniorInfo.toJSON());
        JniorAnnouncementStore.incrementBeaconSeenCount(jniorInfo.getSerialNumber());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this._sorter.sort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showPreviouslySeen() {
        BeaconTableModel beaconTableModel = this._tableModel;
        synchronized (beaconTableModel) {
            JSONObject storeJson = JniorAnnouncementStore.getStoreJSONObject();
            for (String key : storeJson.keySet()) {
                JSONObject jniorObject = storeJson.getJSONObject(key);
                JSONObject jniorDataObject = jniorObject.getJSONObject("Data");
                JniorInfo newJniorInfo = JniorInfo.fromJSON(jniorDataObject);
                this._tableModel.updateJniorInfo(newJniorInfo);
            }
        }
    }
}

