/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.beacon.Beacon;
import com.integ.beacon.JniorInfo;
import com.integ.beacon.commands.QueryCommand;
import com.integ.supporter.JniorItem;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.beacon.BeaconTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class BeaconMenu
extends JMenu {
    private final JMenuBar _menuBar;
    private final BeaconTab _beaconTab;
    private JMenuItem _menuQuery;

    public BeaconMenu(JMenuBar menuBar, BeaconTab beaconTab) {
        super("Beacon");
        this._menuBar = menuBar;
        this._beaconTab = beaconTab;
        this.createMenu();
    }

    private void createMenu() {
        this._menuBar.add(this);
        super.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                Component component = tabbedPane.getSelectedComponent();
                if (component instanceof BeaconTab) {
                    BeaconTab beaconTab = (BeaconTab)component;
                    boolean selectedJniors = 0 < beaconTab.selectedJniorCount();
                    BeaconMenu.this._menuQuery.setEnabled(selectedJniors);
                } else {
                    BeaconMenu.this._menuQuery.setEnabled(false);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenuItem menuQueryAll = new JMenuItem("Query All");
        menuQueryAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeaconMenu.this._beaconTab.queryAll();
            }
        });
        super.add(menuQueryAll);
        this._menuQuery = new JMenuItem("Query");
        this._menuQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JniorItem jniorItem = BeaconMenu.this._beaconTab.getSelectedJniorItem();
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                Beacon.getInstance().broadcastCommand(new QueryCommand(jniorInfo.getSerialNumber()));
            }
        });
        super.add(this._menuQuery);
        super.addSeparator();
        this.addResizeColumnsMenuItem();
        this.addShowPreviouslySeen();
    }

    private void addResizeColumnsMenuItem() {
        JMenuItem resizeColumnsMenuItem = new JMenuItem("Resize Columns");
        resizeColumnsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeaconMenu.this._beaconTab.resizeTableColumns();
            }
        });
        super.add(resizeColumnsMenuItem);
    }

    private void addShowPreviouslySeen() {
        JMenuItem showPreviouslySeenMenuItem = new JMenuItem("Show Previously Seen");
        showPreviouslySeenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeaconMenu.this._beaconTab.showPreviouslySeen();
            }
        });
        super.add(showPreviouslySeenMenuItem);
    }
}

