/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.beacon.Beacon;
import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.ResourceUtils;
import com.integ.supporter.AssemblyInfo;
import com.integ.supporter.DetailsFileChooser;
import com.integ.supporter.FileMenu;
import com.integ.supporter.JniorsConfig;
import com.integ.supporter.NTPClient;
import com.integ.supporter.RollingLog;
import com.integ.supporter.ToolsMenu;
import com.integ.supporter.backup.JniorBackup;
import com.integ.supporter.beacon.BeaconMenu;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.beacon.dialogs.ConsoleDialog;
import com.integ.supporter.cinema.device.DeviceFileMenu;
import com.integ.supporter.cinema.macro.MacroFileMenu;
import com.integ.supporter.snapshot.Snapshot;
import com.integ.supporter.snapshot.SnapshotInProgressCollection;
import com.integ.supporter.snapshot.SnapshotMenu;
import com.integ.supporter.snapshot.SnapshotTab;
import com.integ.supporter.ui.StatusBar;
import com.integ.supporter.updater.BlankUpdateTab;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.UpdateProjectMainMenu;
import com.integ.supporter.updater.UpdateTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SupporterMain
extends JPanel {
    private static final SimpleDateFormat FOLDER_DATE_FORMAT;
    public static SupporterMain INSTANCE;
    private static final String HOME_DIRECTORY;
    private static final String INTEG_DIRECTORY;
    public static final String SUPPORTER_DIRECTORY;
    public static final String TEMP_DIRECTORY;
    public static final String LOGS_DIRECTORY;
    public static final String SNAPSHOT_LOGS_DIRECTORY;
    public static final String CONFIG_DIRECTORY;
    public static final String LISTINGS_DIRECTORY;
    public static final String SNAPSHOTS_FOLDER;
    public static final String UPDATES_LOGS_DIRECTORY;
    public static final String CINEMA_FILES_FOLDER;
    public static BeaconTab BEACON_TAB;
    public static SnapshotTab SNAPSHOT_TAB;
    private static Logger LOGGER;
    private TrayIcon _trayIcon;
    private static JFrame _frame;
    private final JTabbedPane _tabbedPane = new JTabbedPane();
    private final ConsoleDialog _consoleDialog = new ConsoleDialog();
    private BeaconMenu _beaconMenu;
    private SnapshotMenu _snapshotMenu;
    private UpdateProjectMainMenu _updateMenu;
    private DeviceFileMenu _deviceFileMenu;
    private MacroFileMenu _macroFileMenu;
    private final JMenuItem _ntpTimeMenuItem = new JMenuItem("NTP Sync: ");
    private final JMenuItem _ntpOffsetMenuItem = new JMenuItem("NTP Offset: ms");
    private final JMenuItem _ntpElapsedTimeMenuItem = new JMenuItem("NTP elapsed time:");
    public static BlankUpdateTab BLANK_UPDATE_TAB;

    private static void removeAllLckFiles() {
        SupporterMain.removeLckFiles(LOGS_DIRECTORY);
        SupporterMain.removeLckFiles(SNAPSHOT_LOGS_DIRECTORY);
        SupporterMain.removeLckFiles(UPDATES_LOGS_DIRECTORY);
    }

    public static File getTempDirectory() {
        File tempDirectory = new File(TEMP_DIRECTORY);
        if (!tempDirectory.exists()) {
            tempDirectory.mkdir();
        }
        return tempDirectory;
    }

    private static void removeLckFiles(final String directory) {
        System.out.println("remove lock files for " + directory);
        String[] files = new File(directory).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                try {
                    File file;
                    String fullFilename = String.format("%s%s", directory, name);
                    boolean accept = name.endsWith(".lck");
                    if (!accept && (file = new File(fullFilename)).exists() && 0L == file.length()) {
                        accept = true;
                    }
                    return accept;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
        });
        if (null != files) {
            for (int i = files.length - 1; i >= 0; --i) {
                String filenameString = files[i];
                String fullFilename = String.format("%s%s", directory, filenameString);
                File file = new File(fullFilename);
                if (!file.isFile() || !file.delete()) continue;
                System.out.println(" removed " + fullFilename);
            }
        }
    }

    public static void main(String[] args) {
        if (0 < args.length) {
            if ("-backup".equalsIgnoreCase(args[0]) && 2 <= args.length) {
                String host = args[1];
                Logger logger = RollingLog.getLogger(String.format("Snapshot_%s", host));
                try {
                    JniorInfo jniorInfo = new JniorInfo(0);
                    jniorInfo.IpAddress = host;
                    if (4 <= args.length) {
                        jniorInfo.UserName = args[2];
                        jniorInfo.Password = args[3];
                    }
                    Snapshot snapshot = new Snapshot(jniorInfo);
                    String folder = String.format("%s%s_%s", TEMP_DIRECTORY, jniorInfo.IpAddress, FOLDER_DATE_FORMAT.format(new Date()));
                    snapshot.setFolder(folder);
                    snapshot.setLogger(logger);
                    snapshot.execute();
                }
                catch (Exception jniorInfo) {
                    // empty catch block
                }
                Set<Thread> threads = Thread.getAllStackTraces().keySet();
                for (Thread t : threads) {
                    String name = t.getName();
                    Thread.State state = t.getState();
                    int priority = t.getPriority();
                    String type = t.isDaemon() ? "Daemon" : "Normal";
                    System.out.printf("%-20s \t %s \t %d \t %s %s\n", new Object[]{name, state, priority, type, t.getClass()});
                }
            }
        } else {
            BEACON_TAB = new BeaconTab();
            SNAPSHOT_TAB = new SnapshotTab();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SupporterMain.createAndShowGUI();
                }
            });
        }
    }

    private static void createAndShowGUI() {
        _frame = new JFrame(AssemblyInfo.getName() + " v" + AssemblyInfo.getVersion());
        _frame.setDefaultCloseOperation(0);
        _frame.setMinimumSize(new Dimension(600, 400));
        _frame.setExtendedState(6);
        final SupporterMain supporterMain = new SupporterMain();
        _frame.add((Component)supporterMain, "Center");
        _frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                supporterMain.tryExit();
            }
        });
        try {
            URL iconURL = supporterMain.getClass().getResource("/resources/integ.png");
            ImageIcon icon = new ImageIcon(iconURL);
            _frame.setIconImage(icon.getImage());
        }
        catch (Exception ex) {
            LOGGER.severe(ExceptionUtils.getStackTrace(ex));
        }
        _frame.setVisible(true);
    }

    public SupporterMain() {
        super(new BorderLayout());
        INSTANCE = this;
        if (SystemTray.isSupported()) {
            try {
                SystemTray tray = SystemTray.getSystemTray();
                URL iconURL = this.getClass().getResource("/resources/integ.png");
                ImageIcon icon = new ImageIcon(iconURL);
                this._trayIcon = new TrayIcon(icon.getImage(), "JNIOR Supporter");
                this._trayIcon.setImageAutoSize(true);
                tray.add(this._trayIcon);
            }
            catch (Exception ex) {
                LOGGER.severe(ExceptionUtils.getStackTrace(ex));
            }
        }
        this.addMenu();
        this.addTabbedPane();
        StatusBar.addStatusBar(this);
        JniorsConfig.init();
        System.out.println("Start GUI");
        Beacon.getInstance().addBeaconListener(SNAPSHOT_TAB);
        Beacon.getInstance().start();
        this.getNetworkTime();
    }

    public void playSound(String soundFileName) {
        try {
            String tempFilePath = String.format("%s/%d_%s", SupporterMain.getTempDirectory(), System.currentTimeMillis(), soundFileName);
            File tempAudioFile = new File(tempFilePath);
            ResourceUtils.extractResource("/resources/" + soundFileName, tempAudioFile);
            AudioInputStream stream = AudioSystem.getAudioInputStream(tempAudioFile);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
            clip.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void displayMessage(String caption, String text, TrayIcon.MessageType messageType) {
        if (null != this._trayIcon) {
            this._trayIcon.displayMessage(caption, text, messageType);
        }
    }

    private void addMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.add((Component)menuBar, "North");
        this.addFileMenu(menuBar);
        this._beaconMenu = new BeaconMenu(menuBar, BEACON_TAB);
        this._snapshotMenu = new SnapshotMenu(menuBar);
        this._updateMenu = new UpdateProjectMainMenu(menuBar);
        this._deviceFileMenu = new DeviceFileMenu(menuBar);
        this._deviceFileMenu.setVisible(false);
        this._macroFileMenu = new MacroFileMenu(menuBar);
        this._macroFileMenu.setVisible(false);
        menuBar.add(new ToolsMenu());
        this.addHelpMenu(menuBar);
    }

    private void addFileMenu(JMenuBar menuBar) {
        FileMenu fileMenu = new FileMenu(menuBar);
        fileMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("OpenUpdateProject".equalsIgnoreCase(e.getActionCommand())) {
                    SupporterMain.openUpdateProject();
                } else if ("OpenUpdateProject".equalsIgnoreCase(e.getActionCommand())) {
                    SupporterMain.openSnapshotUpdateProject();
                } else if ("Exit".equalsIgnoreCase(e.getActionCommand())) {
                    SupporterMain.this.tryExit();
                }
            }
        });
    }

    public void tryExit() {
        try {
            int canExit = 0;
            int snapshotsInProgressCount = SnapshotInProgressCollection.getInProgressCount();
            String snapshotsInProgressString = 1 == snapshotsInProgressCount ? "is 1 Snapshot" : String.format("are %d Snapshots", snapshotsInProgressCount);
            int updatesInProgressCount = 0;
            for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
                Component component = this._tabbedPane.getComponentAt(i);
                if (!(component instanceof UpdateTab)) continue;
                UpdateTab updateTab = (UpdateTab)component;
                updatesInProgressCount += updateTab.getUpdatesInProgressCount();
            }
            if (0 < snapshotsInProgressCount && 0 < updatesInProgressCount) {
                String updatesInProgressString = 1 == updatesInProgressCount ? "1 Update" : String.format("%d Updates", updatesInProgressCount);
                canExit = JOptionPane.showConfirmDialog(_frame, String.format("There %s and %s in progress.  Do you want to abort them and exit?", snapshotsInProgressString, updatesInProgressString), "Snapshots and Updates in progress", 0, 1);
            } else if (0 < snapshotsInProgressCount) {
                canExit = JOptionPane.showConfirmDialog(_frame, String.format("There %s in progress.  Do you want to abort them and exit?", snapshotsInProgressString), "Snapshots in progress", 0, 1);
            } else if (0 < updatesInProgressCount) {
                String updatesInProgressString = 1 == updatesInProgressCount ? "is 1 Update" : String.format("are %d Updates", updatesInProgressCount);
                canExit = JOptionPane.showConfirmDialog(_frame, String.format("There %s in progress.  Do you want to abort them and exit?", updatesInProgressString), "Updates in progress", 0, 1);
            }
            if (0 == canExit) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            String stackTrace = ExceptionUtils.getStackTrace(ex);
            LOGGER.severe(stackTrace);
            JOptionPane.showMessageDialog(this, "Error trying to exit", stackTrace, 0);
            System.exit(-1);
        }
    }

    public static void openUpdateProject() {
        DetailsFileChooser fileChooser = new DetailsFileChooser();
        fileChooser.setCurrentDirectory(new File(UpdateTab.UPDATE_PROJECTS_FOLDER));
        fileChooser.setFileSelectionMode(0);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("JNIOR Update Project", "zip"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        int result = fileChooser.showOpenDialog(_frame.getRootPane());
        if (result == 0) {
            try {
                File selectedFile = fileChooser.getSelectedFile();
                UpdateProjectFile updateProjectFile = new UpdateProjectFile(selectedFile);
                updateProjectFile.load();
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                UpdateTab updateTab = new UpdateTab(updateProjectFile);
                String title = String.format("Update - %s", updateProjectFile.getTitle());
                int tabCount = tabbedPane.getTabCount();
                tabbedPane.insertTab(title, null, updateTab, title, tabCount);
                tabbedPane.setSelectedIndex(tabCount);
                if (-1 != tabbedPane.indexOfComponent(BLANK_UPDATE_TAB)) {
                    tabbedPane.remove(BLANK_UPDATE_TAB);
                }
            }
            catch (IOException ex) {
                String stacktrace = ExceptionUtils.getStackTrace(ex);
                Logger.getGlobal().severe(stacktrace);
            }
        }
    }

    public static void openSnapshotUpdateProject() {
    }

    public void updateClosed() {
        boolean isUpdateOpen = false;
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            String tabTitle = this._tabbedPane.getTitleAt(i);
            if (!tabTitle.startsWith("Update")) continue;
            isUpdateOpen = true;
            break;
        }
        if (!isUpdateOpen && -1 == this._tabbedPane.indexOfComponent(BLANK_UPDATE_TAB)) {
            this.addBlankUpdateTab();
        }
    }

    private void addHelpMenu(JMenuBar menuBar) {
        JMenu menuHelp = new JMenu("Help");
        menuBar.add(menuHelp);
        JMenuItem menuHelpConsoleWindow = new JMenuItem("Console Window");
        menuHelpConsoleWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SupporterMain.this._consoleDialog.open();
            }
        });
        menuHelp.add(menuHelpConsoleWindow);
        this._ntpTimeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SupporterMain.this.getNetworkTime();
            }
        });
        menuHelp.add(this._ntpTimeMenuItem);
        menuHelp.add(this._ntpOffsetMenuItem);
        menuHelp.add(this._ntpElapsedTimeMenuItem);
    }

    private void getNetworkTime() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Date networkTime = NTPClient.getNetworkTime(true);
                System.out.println("networkTime: " + networkTime);
                if (null != networkTime) {
                    SupporterMain.this._ntpTimeMenuItem.setText("NTP Sync: " + networkTime.toString());
                    SupporterMain.this._ntpOffsetMenuItem.setText("NTP Offset: " + NTPClient.getOffset() + "ms");
                    SupporterMain.this._ntpElapsedTimeMenuItem.setText("NTP elapsed time: " + NTPClient.getElapsedTime() + "s");
                }
            }
        }).start();
    }

    private void addTabbedPane() {
        this.add((Component)this._tabbedPane, "Center");
        this._tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component component = SupporterMain.this._tabbedPane.getSelectedComponent();
                if (component == BLANK_UPDATE_TAB) {
                    SupporterMain.openUpdateProject();
                } else if (component == SNAPSHOT_TAB) {
                    SNAPSHOT_TAB.shouldShowSnapshotNeededNotification();
                }
            }
        });
        this.addBeaconTab();
        this.addSnapshotTab();
        this.addBlankUpdateTab();
    }

    private void addBlankUpdateTab() {
        this._tabbedPane.addTab("Open Update", null, BLANK_UPDATE_TAB, "When clicked, you will be prompted to open an Update Project");
    }

    public static JTabbedPane getTabPane() {
        return SupporterMain.INSTANCE._tabbedPane;
    }

    private void addBeaconTab() {
        this._tabbedPane.addTab("Beacon", null, BEACON_TAB, "Beacon Tab");
        this._tabbedPane.setMnemonicAt(0, 49);
    }

    private void addSnapshotTab() {
        this._tabbedPane.addTab("Snapshot", null, SNAPSHOT_TAB, "Snapshot");
        this._tabbedPane.setMnemonicAt(0, 50);
    }

    public static void setTabTitle(JComponent component, String newTitle) {
        SupporterMain main = INSTANCE;
        JTabbedPane tabbedPane = main._tabbedPane;
        int index = tabbedPane.indexOfComponent(component);
        if (-1 != index) {
            tabbedPane.setTitleAt(index, newTitle);
        }
    }

    public static void setTabBackground(JComponent component, Color color) {
        SupporterMain main = INSTANCE;
        JTabbedPane tabbedPane = main._tabbedPane;
        int index = tabbedPane.indexOfComponent(component);
        if (-1 != index) {
            tabbedPane.setBackgroundAt(index, color);
        }
    }

    public static void showError(String errorMessage) {
        SupporterMain.showError(errorMessage, "Error!");
    }

    public static void showError(Exception exceptionError) {
        String errorMessage = "Message: " + exceptionError.getMessage() + "\nStackTrace: " + Arrays.toString(exceptionError.getStackTrace());
        String title = exceptionError.getClass().getName();
        SupporterMain.showError(errorMessage, title);
    }

    public static void showError(String errorMessage, String title) {
        JOptionPane.showMessageDialog(null, errorMessage, title, 0);
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT %4$-7s %5$s %n");
        FOLDER_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
        HOME_DIRECTORY = System.getProperty("user.home") + File.separatorChar + "Documents";
        INTEG_DIRECTORY = HOME_DIRECTORY + "/INTEG/";
        SUPPORTER_DIRECTORY = INTEG_DIRECTORY + "JavaSupporter/";
        TEMP_DIRECTORY = SUPPORTER_DIRECTORY + "temp/";
        LOGS_DIRECTORY = SUPPORTER_DIRECTORY + "Logs/";
        SNAPSHOT_LOGS_DIRECTORY = LOGS_DIRECTORY + "Snapshots/";
        CONFIG_DIRECTORY = SUPPORTER_DIRECTORY + "Config/";
        LISTINGS_DIRECTORY = CONFIG_DIRECTORY + "Listings/";
        SNAPSHOTS_FOLDER = SUPPORTER_DIRECTORY + "Snapshots/";
        UPDATES_LOGS_DIRECTORY = LOGS_DIRECTORY + "Updates/";
        CINEMA_FILES_FOLDER = SUPPORTER_DIRECTORY + "CinemaFiles/";
        BEACON_TAB = null;
        SNAPSHOT_TAB = null;
        LOGGER = null;
        RollingLog.redirectAllLogging();
        try {
            System.out.println(String.format("HOME_DIRECTORY: %s", HOME_DIRECTORY));
            System.out.println(String.format("SUPPORTER_DIRECTORY: %s", SUPPORTER_DIRECTORY));
            new File(INTEG_DIRECTORY).mkdir();
            new File(SUPPORTER_DIRECTORY).mkdir();
            new File(LOGS_DIRECTORY).mkdir();
            new File(SNAPSHOT_LOGS_DIRECTORY).mkdir();
            new File(UPDATES_LOGS_DIRECTORY).mkdir();
            SupporterMain.removeAllLckFiles();
            LOGGER = RollingLog.getLogger("JniorSupporter");
            LOGGER.info(String.format("%s v%s", AssemblyInfo.getName(), AssemblyInfo.getVersion()));
            RollingLog.setGlobalLogger(LOGGER);
            LOGGER.info(String.format("%s %s (%s)", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.home")));
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    SupporterMain.removeAllLckFiles();
                }
            }));
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        File tempDirectory = new File(TEMP_DIRECTORY);
        try {
            if (tempDirectory.exists()) {
                FileUtils.deleteDirectory(tempDirectory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        tempDirectory.mkdir();
        new File(CONFIG_DIRECTORY).mkdir();
        new File(LISTINGS_DIRECTORY).mkdir();
        new File(SNAPSHOTS_FOLDER).mkdir();
        new File(UpdateTab.UPDATE_PROJECTS_FOLDER).mkdir();
        new File(CINEMA_FILES_FOLDER).mkdir();
        new File(JniorBackup.BACKUP_DIRECTORY).mkdir();
        BLANK_UPDATE_TAB = new BlankUpdateTab();
    }
}

