/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.ResourceUtils;
import com.integ.janoslib.utils.StringUtils;
import com.integ.supporter.SupporterMain;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

public class OpenTelnetConsole {
    private static final Logger LOGGER = Logger.getLogger(OpenTelnetConsole.class.getName());
    private static final File JAVA_CONSOLE_APPLICATION = new File(SupporterMain.TEMP_DIRECTORY + File.separator + "JniorConsoleApplication.jar");
    private final String _host;

    public OpenTelnetConsole(String host) {
        this._host = host;
    }

    public void execute() {
        try {
            boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
            LOGGER.info(String.format("is windows: %s", Boolean.toString(isWindows)));
            File temp_java_console_application = new File(SupporterMain.TEMP_DIRECTORY + File.separator + "JniorConsoleApplication-" + (int)(Math.random() * 100.0) + ".jar");
            LOGGER.info(String.format("%s exists: %s", JAVA_CONSOLE_APPLICATION, String.valueOf(JAVA_CONSOLE_APPLICATION.exists())));
            if (!JAVA_CONSOLE_APPLICATION.exists()) {
                LOGGER.info(String.format("extracting %s", temp_java_console_application));
                ResourceUtils.extractResource("/resources/JniorConsoleApplication.jar", temp_java_console_application);
                LOGGER.info(String.format("extracted %s", temp_java_console_application));
            }
            ArrayList<String> cmdArrayList = new ArrayList<String>();
            if (isWindows) {
                Collections.addAll(cmdArrayList, "cmd", "/c");
            } else {
                Collections.addAll(cmdArrayList, "sh", "-c");
            }
            Collections.addAll(cmdArrayList, "java", "-jar", "\"" + temp_java_console_application.getPath() + "\"");
            cmdArrayList.add(this._host);
            String[] cmdArray = cmdArrayList.toArray(new String[cmdArrayList.size()]);
            LOGGER.info(String.format("%s", StringUtils.join(cmdArray, ", ")));
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(cmdArray);
            LOGGER.info(String.format("executing %s for %s", temp_java_console_application, this._host));
        }
        catch (Exception ex) {
            LOGGER.severe(ExceptionUtils.getStackTrace(ex));
        }
    }
}

