/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.supporter.ConfigFile;
import com.integ.supporter.SupporterMain;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApplicationConfig
extends ConfigFile {
    private static final File APPLICATION_CONFIG_JSON_FILE = new File(SupporterMain.CONFIG_DIRECTORY + "ApplicationConfig.json");
    private static final ApplicationConfig INSTANCE = new ApplicationConfig();
    private JSONObject _applicationConfigJson = new JSONObject();

    private ApplicationConfig() {
        super(APPLICATION_CONFIG_JSON_FILE);
    }

    @Override
    protected void loadConfig() {
        super.loadConfig();
        if (!this._configJson.has("ApplicationConfig")) {
            this._configJson.put("ApplicationConfig", new JSONObject());
        }
        this._applicationConfigJson = this._configJson.getJSONObject("ApplicationConfig");
        ApplicationConfig.getSnapshotAlertPeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getBeaconColumnWidths() {
        File file = APPLICATION_CONFIG_JSON_FILE;
        synchronized (file) {
            INSTANCE.shouldReloadConfig();
            int[] columnWidths = new int[]{};
            JSONArray array = ApplicationConfig.INSTANCE._applicationConfigJson.optJSONArray("BeaconColumnWidths");
            if (array != null) {
                columnWidths = new int[array.length()];
                for (int i = 0; i < array.length(); ++i) {
                    columnWidths[i] = array.optInt(i);
                }
            }
            return columnWidths;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBeaconColumnWidths(int[] columnWidths) {
        File file = APPLICATION_CONFIG_JSON_FILE;
        synchronized (file) {
            INSTANCE.shouldReloadConfig();
            ApplicationConfig.INSTANCE._applicationConfigJson.put("BeaconColumnWidths", columnWidths);
            INSTANCE.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextSnapshotAlertTime() {
        File file = APPLICATION_CONFIG_JSON_FILE;
        synchronized (file) {
            INSTANCE.shouldReloadConfig();
            long time = ApplicationConfig.INSTANCE._applicationConfigJson.optLong("NextSnapshotAlertTime");
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNextSnapshotAlertTime(long time) {
        File file = APPLICATION_CONFIG_JSON_FILE;
        synchronized (file) {
            INSTANCE.shouldReloadConfig();
            ApplicationConfig.INSTANCE._applicationConfigJson.put("NextSnapshotAlertTime", time);
            INSTANCE.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSnapshotAlertPeriod() {
        File file = APPLICATION_CONFIG_JSON_FILE;
        synchronized (file) {
            INSTANCE.shouldReloadConfig();
            long numberOfDays = ApplicationConfig.INSTANCE._applicationConfigJson.optLong("SnapshotAlertPeriodDays", 14L);
            return numberOfDays;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSnapshotAlertPeriod(int numberOfDays) {
        File file = APPLICATION_CONFIG_JSON_FILE;
        synchronized (file) {
            INSTANCE.shouldReloadConfig();
            ApplicationConfig.INSTANCE._applicationConfigJson.put("SnapshotAlertPeriodDays", numberOfDays);
            INSTANCE.saveConfig();
        }
    }
}

